/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.MapOutput;
import org.kie.kogito.MappableToModel;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.examples.FlightsModel;
import org.kie.kogito.examples.FlightsModelInput;
import org.kie.kogito.examples.FlightsModelOutput;
import org.kie.kogito.examples.Flights_18_TaskModel;
import org.kie.kogito.examples.Flights_18_TaskOutput;
import org.kie.kogito.examples.Flights_6_TaskModel;
import org.kie.kogito.examples.Flights_6_TaskOutput;
import org.kie.kogito.examples.Flights_7_TaskModel;
import org.kie.kogito.examples.Flights_7_TaskOutput;
import org.kie.kogito.examples.Flights_TaskModelFactory;
import org.kie.kogito.examples.domain.Flight;
import org.kie.kogito.examples.domain.PassengerDTO;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessService;
import org.kie.kogito.process.workitem.Attachment;
import org.kie.kogito.process.workitem.AttachmentInfo;
import org.kie.kogito.process.workitem.Comment;
import org.kie.kogito.process.workitem.TaskModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/flights"})
@Component
public class FlightsResource {
    @Autowired
    @Qualifier(value="flights")
    Process<FlightsModel> process;
    @Autowired
    ProcessService processService;

    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> createResource_flights(@RequestHeader HttpHeaders httpHeaders, @RequestParam(value="businessKey", required=false) String businessKey, @RequestBody(required=false) @Valid @NotNull FlightsModelInput resource, UriComponentsBuilder uriComponentsBuilder) {
        ProcessInstance pi = this.processService.createProcessInstance(this.process, businessKey, (Model)Optional.ofNullable(resource).orElse(new FlightsModelInput()).toModel(), (String)httpHeaders.getOrEmpty((Object)"X-KOGITO-StartFromNode").stream().findFirst().orElse(null));
        return ResponseEntity.created((URI)uriComponentsBuilder.path("/flights/{id}").buildAndExpand(new Object[]{pi.id()}).toUri()).body((Object)((FlightsModel)pi.checkError().variables()).toModel());
    }

    @GetMapping(produces={"application/json"})
    public List<FlightsModelOutput> getResources_flights() {
        return this.processService.getProcessInstanceOutput(this.process);
    }

    @GetMapping(value={"/schema"}, produces={"application/json"})
    public Map<String, Object> getResourceSchema_flights() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id());
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public FlightsModelOutput getResource_flights(@PathVariable(value="id") String id) {
        return (FlightsModelOutput)this.processService.findById(this.process, id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}"}, produces={"application/json"})
    public FlightsModelOutput deleteResource_flights(@PathVariable(value="id") String id) {
        return (FlightsModelOutput)this.processService.delete(this.process, id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}"}, produces={"application/json"}, consumes={"application/json"})
    public FlightsModelOutput updateModel_flights(@PathVariable(value="id") String id, @RequestBody(required=false) FlightsModel resource) {
        return (FlightsModelOutput)this.processService.update(this.process, id, (MappableToModel)resource).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/tasks"}, produces={"application/json"})
    public List<TaskModel> getTasks_flights(@PathVariable(value="id") String id, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return ((List)this.processService.getTasks(this.process, id, SecurityPolicy.of((IdentityProvider)IdentityProviders.of((String)user, groups))).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND))).stream().map(Flights_TaskModelFactory::from).collect(Collectors.toList());
    }

    @PostMapping(value={"/{id}/solvingTerminated"}, produces={"application/json"}, consumes={"application/json"})
    public FlightsModelOutput signal_0(@PathVariable(value="id") String id, @RequestBody(required=false) Flight data) {
        return (FlightsModelOutput)this.processService.signalProcessInstance(this.process, id, (Object)data, "solvingTerminated").orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/newPassengerRequest"}, produces={"application/json"}, consumes={"application/json"})
    public FlightsModelOutput signal_1(@PathVariable(value="id") String id, @RequestBody(required=false) PassengerDTO data) {
        return (FlightsModelOutput)this.processService.signalProcessInstance(this.process, id, (Object)data, "newPassengerRequest").orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/New_Best_Solution"}, produces={"application/json"}, consumes={"application/json"})
    public FlightsModelOutput signal_2(@PathVariable(value="id") String id) {
        return (FlightsModelOutput)this.processService.signalProcessInstance(this.process, id, null, "New Best Solution").orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/newSolution"}, produces={"application/json"}, consumes={"application/json"})
    public FlightsModelOutput signal_3(@PathVariable(value="id") String id, @RequestBody(required=false) Flight data) {
        return (FlightsModelOutput)this.processService.signalProcessInstance(this.process, id, (Object)data, "newSolution").orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/Passenger_Boarding_Request"}, produces={"application/json"}, consumes={"application/json"})
    public FlightsModelOutput signal_4(@PathVariable(value="id") String id) {
        return (FlightsModelOutput)this.processService.signalProcessInstance(this.process, id, null, "Passenger Boarding Request").orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/phases/{phase}"}, produces={"application/json"}, consumes={"application/json"})
    public FlightsModelOutput completeTask_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="phase") String phase, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups, @RequestBody(required=false) Flights_6_TaskOutput model) {
        return (FlightsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), (MapOutput)model).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/finalizeSeatAssignment/{taskId}"}, consumes={"application/json"})
    public Flights_6_TaskOutput saveTask_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Flights_6_TaskOutput model) {
        return (Flights_6_TaskOutput)this.processService.saveTask(this.process, id, taskId, SecurityPolicy.of((String)user, groups), (MapOutput)model, Flights_6_TaskOutput::fromMap).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/finalizeSeatAssignment/{taskId}"}, produces={"application/json"}, consumes={"application/json"})
    public FlightsModelOutput taskTransition_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Flights_6_TaskOutput model) {
        return (FlightsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), (MapOutput)model).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/finalizeSeatAssignment/{taskId}"}, produces={"application/json"})
    public Flights_6_TaskModel getTask_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Flights_6_TaskModel)this.processService.getTask(this.process, id, taskId, SecurityPolicy.of((String)user, groups), Flights_6_TaskModel::from).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/finalizeSeatAssignment/{taskId}"}, produces={"application/json"})
    public FlightsModelOutput abortTask_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (FlightsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), null).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"finalizeSeatAssignment/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_finalizeSeatAssignment_5() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"finalizeSeatAssignment");
    }

    @GetMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.getSchemaAndPhases(this.process, id, taskId, "finalizeSeatAssignment", SecurityPolicy.of((String)user, groups));
    }

    @PostMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/comments"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> addComment_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String commentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return this.processService.addComment(this.process, id, taskId, SecurityPolicy.of((String)user, groups), commentInfo).map(comment -> ResponseEntity.created((URI)uriComponentsBuilder.path("/flights/{id}/finalizeSeatAssignment/{taskId}/comments/{commentId}").buildAndExpand(new Object[]{id, taskId, comment.getId().toString()}).toUri()).body(comment)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/comments/{commentId}"}, produces={"application/json"}, consumes={"text/plain"})
    public Comment updateComment_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String comment) {
        return (Comment)this.processService.updateComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups), comment).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/comments/{commentId}"})
    public ResponseEntity deleteComment_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.deleteComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups)).map(removed -> removed != false ? ResponseEntity.ok().build() : ResponseEntity.notFound().build()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/attachments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> addAttachment_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachmentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return this.processService.addAttachment(this.process, id, taskId, SecurityPolicy.of((String)user, groups), attachmentInfo).map(attachment -> ResponseEntity.created((URI)uriComponentsBuilder.path("/flights/{id}/finalizeSeatAssignment/{taskId}/attachments/{attachmentId}").buildAndExpand(new Object[]{id, taskId, attachment.getId()}).toUri()).body(attachment)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/attachments/{attachmentId}"}, produces={"application/json"}, consumes={"application/json"})
    public Attachment updateAttachment_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachment) {
        return (Attachment)this.processService.updateAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups), attachment).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/attachments/{attachmentId}"})
    public ResponseEntity deleteAttachment_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.deleteAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups)).map(removed -> (removed != false ? ResponseEntity.ok() : ResponseEntity.notFound()).build()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/attachments/{attachmentId}"}, produces={"application/json"})
    public Attachment getAttachment_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Attachment)this.processService.getAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Attachment " + attachmentId + " not found"));
    }

    @GetMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/attachments"}, produces={"application/json"})
    public Collection<Attachment> getAttachments_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups) {
        return (Collection)this.processService.getAttachments(this.process, id, taskId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/comments/{commentId}"}, produces={"application/json"})
    public Comment getComment_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Comment)this.processService.getComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Comment " + commentId + " not found"));
    }

    @GetMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/comments"}, produces={"application/json"})
    public Collection<Comment> getComments_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Collection)this.processService.getComments(this.process, id, taskId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/finalizePassengerList/{taskId}/phases/{phase}"}, produces={"application/json"}, consumes={"application/json"})
    public FlightsModelOutput completeTask_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="phase") String phase, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups, @RequestBody(required=false) Flights_7_TaskOutput model) {
        return (FlightsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), (MapOutput)model).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/finalizePassengerList/{taskId}"}, consumes={"application/json"})
    public Flights_7_TaskOutput saveTask_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Flights_7_TaskOutput model) {
        return (Flights_7_TaskOutput)this.processService.saveTask(this.process, id, taskId, SecurityPolicy.of((String)user, groups), (MapOutput)model, Flights_7_TaskOutput::fromMap).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/finalizePassengerList/{taskId}"}, produces={"application/json"}, consumes={"application/json"})
    public FlightsModelOutput taskTransition_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Flights_7_TaskOutput model) {
        return (FlightsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), (MapOutput)model).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/finalizePassengerList/{taskId}"}, produces={"application/json"})
    public Flights_7_TaskModel getTask_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Flights_7_TaskModel)this.processService.getTask(this.process, id, taskId, SecurityPolicy.of((String)user, groups), Flights_7_TaskModel::from).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/finalizePassengerList/{taskId}"}, produces={"application/json"})
    public FlightsModelOutput abortTask_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (FlightsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), null).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"finalizePassengerList/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_finalizePassengerList_6() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"finalizePassengerList");
    }

    @GetMapping(value={"/{id}/finalizePassengerList/{taskId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.getSchemaAndPhases(this.process, id, taskId, "finalizePassengerList", SecurityPolicy.of((String)user, groups));
    }

    @PostMapping(value={"/{id}/finalizePassengerList/{taskId}/comments"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> addComment_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String commentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return this.processService.addComment(this.process, id, taskId, SecurityPolicy.of((String)user, groups), commentInfo).map(comment -> ResponseEntity.created((URI)uriComponentsBuilder.path("/flights/{id}/finalizePassengerList/{taskId}/comments/{commentId}").buildAndExpand(new Object[]{id, taskId, comment.getId().toString()}).toUri()).body(comment)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/finalizePassengerList/{taskId}/comments/{commentId}"}, produces={"application/json"}, consumes={"text/plain"})
    public Comment updateComment_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String comment) {
        return (Comment)this.processService.updateComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups), comment).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/finalizePassengerList/{taskId}/comments/{commentId}"})
    public ResponseEntity deleteComment_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.deleteComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups)).map(removed -> removed != false ? ResponseEntity.ok().build() : ResponseEntity.notFound().build()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/finalizePassengerList/{taskId}/attachments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> addAttachment_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachmentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return this.processService.addAttachment(this.process, id, taskId, SecurityPolicy.of((String)user, groups), attachmentInfo).map(attachment -> ResponseEntity.created((URI)uriComponentsBuilder.path("/flights/{id}/finalizePassengerList/{taskId}/attachments/{attachmentId}").buildAndExpand(new Object[]{id, taskId, attachment.getId()}).toUri()).body(attachment)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/finalizePassengerList/{taskId}/attachments/{attachmentId}"}, produces={"application/json"}, consumes={"application/json"})
    public Attachment updateAttachment_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachment) {
        return (Attachment)this.processService.updateAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups), attachment).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/finalizePassengerList/{taskId}/attachments/{attachmentId}"})
    public ResponseEntity deleteAttachment_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.deleteAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups)).map(removed -> (removed != false ? ResponseEntity.ok() : ResponseEntity.notFound()).build()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/finalizePassengerList/{taskId}/attachments/{attachmentId}"}, produces={"application/json"})
    public Attachment getAttachment_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Attachment)this.processService.getAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Attachment " + attachmentId + " not found"));
    }

    @GetMapping(value={"/{id}/finalizePassengerList/{taskId}/attachments"}, produces={"application/json"})
    public Collection<Attachment> getAttachments_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups) {
        return (Collection)this.processService.getAttachments(this.process, id, taskId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/finalizePassengerList/{taskId}/comments/{commentId}"}, produces={"application/json"})
    public Comment getComment_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Comment)this.processService.getComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Comment " + commentId + " not found"));
    }

    @GetMapping(value={"/{id}/finalizePassengerList/{taskId}/comments"}, produces={"application/json"})
    public Collection<Comment> getComments_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Collection)this.processService.getComments(this.process, id, taskId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/approveDenyPassenger/{taskId}/phases/{phase}"}, produces={"application/json"}, consumes={"application/json"})
    public FlightsModelOutput completeTask_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="phase") String phase, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups, @RequestBody(required=false) Flights_18_TaskOutput model) {
        return (FlightsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), (MapOutput)model).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/approveDenyPassenger/{taskId}"}, consumes={"application/json"})
    public Flights_18_TaskOutput saveTask_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Flights_18_TaskOutput model) {
        return (Flights_18_TaskOutput)this.processService.saveTask(this.process, id, taskId, SecurityPolicy.of((String)user, groups), (MapOutput)model, Flights_18_TaskOutput::fromMap).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/approveDenyPassenger/{taskId}"}, produces={"application/json"}, consumes={"application/json"})
    public FlightsModelOutput taskTransition_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Flights_18_TaskOutput model) {
        return (FlightsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), (MapOutput)model).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/approveDenyPassenger/{taskId}"}, produces={"application/json"})
    public Flights_18_TaskModel getTask_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Flights_18_TaskModel)this.processService.getTask(this.process, id, taskId, SecurityPolicy.of((String)user, groups), Flights_18_TaskModel::from).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/approveDenyPassenger/{taskId}"}, produces={"application/json"})
    public FlightsModelOutput abortTask_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (FlightsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), null).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"approveDenyPassenger/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_approveDenyPassenger_7() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"approveDenyPassenger");
    }

    @GetMapping(value={"/{id}/approveDenyPassenger/{taskId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.getSchemaAndPhases(this.process, id, taskId, "approveDenyPassenger", SecurityPolicy.of((String)user, groups));
    }

    @PostMapping(value={"/{id}/approveDenyPassenger/{taskId}/comments"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> addComment_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String commentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return this.processService.addComment(this.process, id, taskId, SecurityPolicy.of((String)user, groups), commentInfo).map(comment -> ResponseEntity.created((URI)uriComponentsBuilder.path("/flights/{id}/approveDenyPassenger/{taskId}/comments/{commentId}").buildAndExpand(new Object[]{id, taskId, comment.getId().toString()}).toUri()).body(comment)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/approveDenyPassenger/{taskId}/comments/{commentId}"}, produces={"application/json"}, consumes={"text/plain"})
    public Comment updateComment_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String comment) {
        return (Comment)this.processService.updateComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups), comment).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/approveDenyPassenger/{taskId}/comments/{commentId}"})
    public ResponseEntity deleteComment_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.deleteComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups)).map(removed -> removed != false ? ResponseEntity.ok().build() : ResponseEntity.notFound().build()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/approveDenyPassenger/{taskId}/attachments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> addAttachment_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachmentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return this.processService.addAttachment(this.process, id, taskId, SecurityPolicy.of((String)user, groups), attachmentInfo).map(attachment -> ResponseEntity.created((URI)uriComponentsBuilder.path("/flights/{id}/approveDenyPassenger/{taskId}/attachments/{attachmentId}").buildAndExpand(new Object[]{id, taskId, attachment.getId()}).toUri()).body(attachment)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/approveDenyPassenger/{taskId}/attachments/{attachmentId}"}, produces={"application/json"}, consumes={"application/json"})
    public Attachment updateAttachment_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachment) {
        return (Attachment)this.processService.updateAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups), attachment).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/approveDenyPassenger/{taskId}/attachments/{attachmentId}"})
    public ResponseEntity deleteAttachment_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.deleteAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups)).map(removed -> (removed != false ? ResponseEntity.ok() : ResponseEntity.notFound()).build()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/approveDenyPassenger/{taskId}/attachments/{attachmentId}"}, produces={"application/json"})
    public Attachment getAttachment_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Attachment)this.processService.getAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Attachment " + attachmentId + " not found"));
    }

    @GetMapping(value={"/{id}/approveDenyPassenger/{taskId}/attachments"}, produces={"application/json"})
    public Collection<Attachment> getAttachments_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups) {
        return (Collection)this.processService.getAttachments(this.process, id, taskId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/approveDenyPassenger/{taskId}/comments/{commentId}"}, produces={"application/json"})
    public Comment getComment_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Comment)this.processService.getComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Comment " + commentId + " not found"));
    }

    @GetMapping(value={"/{id}/approveDenyPassenger/{taskId}/comments"}, produces={"application/json"})
    public Collection<Comment> getComments_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Collection)this.processService.getComments(this.process, id, taskId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }
}

