/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.domain;

import java.util.Objects;
import org.kie.kogito.examples.domain.SeatType;
import org.optaplanner.core.api.domain.lookup.PlanningId;

public class Seat {
    @PlanningId
    private final String name;
    private final int row;
    private final int column;
    private final SeatType seatType;
    private final boolean emergencyExitRow;

    public Seat(int row, int column, SeatType seatType, boolean emergencyExitRow) {
        this.row = row;
        this.column = column;
        this.name = row + 1 + Character.toString((char)(65 + column));
        this.seatType = seatType;
        this.emergencyExitRow = emergencyExitRow;
    }

    public String getName() {
        return this.name;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public SeatType getSeatType() {
        return this.seatType;
    }

    public boolean isEmergencyExitRow() {
        return this.emergencyExitRow;
    }

    public boolean equals(Object o) {
        if (o instanceof Seat) {
            Seat other = (Seat)o;
            return this.row == other.row && this.column == other.column && this.seatType.equals((Object)other.getSeatType()) && this.emergencyExitRow == other.emergencyExitRow;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.row, this.column, this.seatType, this.emergencyExitRow);
    }
}

