/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.domain;

import java.time.LocalDateTime;
import java.util.List;
import org.kie.kogito.examples.domain.FlightInfo;
import org.kie.kogito.examples.domain.Passenger;
import org.kie.kogito.examples.domain.Seat;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.ProblemFactCollectionProperty;
import org.optaplanner.core.api.domain.solution.ProblemFactProperty;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;

@PlanningSolution
public class Flight {
    @ProblemFactProperty
    private FlightInfo flightInfo = new FlightInfo();
    @ProblemFactCollectionProperty
    @ValueRangeProvider(id="seatRange")
    private List<Seat> seatList;
    @PlanningEntityCollectionProperty
    private List<Passenger> passengerList;
    @PlanningScore
    private HardSoftScore score;

    public FlightInfo getFlightInfo() {
        return this.flightInfo;
    }

    public void setFlightInfo(FlightInfo flightInfo) {
        this.flightInfo = flightInfo;
    }

    public String getOrigin() {
        return this.flightInfo.getOrigin();
    }

    public void setOrigin(String origin) {
        this.flightInfo.setOrigin(origin);
    }

    public String getDestination() {
        return this.flightInfo.getDestination();
    }

    public void setDestination(String destination) {
        this.flightInfo.setDestination(destination);
    }

    public LocalDateTime getDepartureDateTime() {
        return this.flightInfo.getDepartureDateTime();
    }

    public void setDepartureDateTime(LocalDateTime departureDateTime) {
        this.flightInfo.setDepartureDateTime(departureDateTime);
    }

    public int getSeatRowSize() {
        return this.flightInfo.getSeatRowSize();
    }

    public void setSeatRowSize(int seatRowSize) {
        this.flightInfo.setSeatRowSize(seatRowSize);
    }

    public int getSeatColumnSize() {
        return this.flightInfo.getSeatColumnSize();
    }

    public void setSeatColumnSize(int seatColumnSize) {
        this.flightInfo.setSeatColumnSize(seatColumnSize);
    }

    public List<Seat> getSeatList() {
        return this.seatList;
    }

    public void setSeatList(List<Seat> seatList) {
        this.seatList = seatList;
    }

    public List<Passenger> getPassengerList() {
        return this.passengerList;
    }

    public void setPassengerList(List<Passenger> passengerList) {
        this.passengerList = passengerList;
    }

    public HardSoftScore getScore() {
        return this.score;
    }

    public void setScore(HardSoftScore score) {
        this.score = score;
    }
}

