/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.kie.kogito.Model;
import org.kie.kogito.examples.FlightSeatingApplication;
import org.kie.kogito.examples.domain.FlightDTO;
import org.kie.kogito.examples.domain.PassengerDTO;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.process.workitem.Policy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={FlightSeatingApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class FlightTest {
    @Autowired
    Processes processMaker;

    @Test
    public void runProcess() {
        Process process = this.processMaker.processById("flights");
        Assert.assertNotNull((Object)process);
        FlightDTO flightParams = new FlightDTO();
        flightParams.setDepartureDateTime(LocalDateTime.now().toString());
        flightParams.setDestination("");
        flightParams.setOrigin("");
        flightParams.setSeatColumnSize(10);
        flightParams.setSeatRowSize(6);
        Model m = (Model)process.createModel();
        HashMap<String, FlightDTO> parameters = new HashMap<String, FlightDTO>();
        parameters.put("params", flightParams);
        m.fromMap(parameters);
        ProcessInstance processInstance = process.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)1, (int)processInstance.status());
        processInstance.send(Sig.of((String)"newPassengerRequest", (Object)new PassengerDTO("john", "NONE", false, false, null)));
        List tasks = processInstance.workItems(new Policy[0]);
        Assertions.assertEquals((int)2, (int)tasks.size());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("isPassengerApproved", true);
        processInstance.completeWorkItem(((WorkItem)tasks.get(1)).getId(), result, new Policy[0]);
        result = new HashMap();
        result.put("isPassengerListFinalized", true);
        processInstance.completeWorkItem(((WorkItem)tasks.get(0)).getId(), result, new Policy[0]);
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        tasks = processInstance.workItems(new Policy[0]);
        Assertions.assertEquals((int)1, (int)tasks.size());
        processInstance.completeWorkItem(((WorkItem)tasks.get(0)).getId(), null, new Policy[0]);
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Model resultData = (Model)processInstance.variables();
        Assertions.assertEquals((int)5, (int)resultData.toMap().size());
    }
}

