/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.jbpm.process.instance.impl.humantask.HumanTaskHelper;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.Application;
import org.kie.kogito.MapOutput;
import org.kie.kogito.examples.FlightsModel;
import org.kie.kogito.examples.FlightsModelInput;
import org.kie.kogito.examples.FlightsModelOutput;
import org.kie.kogito.examples.Flights_18_TaskModel;
import org.kie.kogito.examples.Flights_18_TaskOutput;
import org.kie.kogito.examples.Flights_6_TaskModel;
import org.kie.kogito.examples.Flights_6_TaskOutput;
import org.kie.kogito.examples.Flights_7_TaskModel;
import org.kie.kogito.examples.Flights_7_TaskOutput;
import org.kie.kogito.examples.Flights_TaskModelFactory;
import org.kie.kogito.examples.domain.Flight;
import org.kie.kogito.examples.domain.PassengerDTO;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.process.workitem.Attachment;
import org.kie.kogito.process.workitem.AttachmentInfo;
import org.kie.kogito.process.workitem.Comment;
import org.kie.kogito.process.workitem.Policies;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.TaskModel;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/flights"})
@Component
public class FlightsResource {
    @Autowired
    @Qualifier(value="flights")
    Process<FlightsModel> process;
    @Autowired
    Application application;

    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> createResource_flights(@RequestHeader HttpHeaders httpHeaders, @RequestParam(value="businessKey", required=false) String businessKey, @RequestBody(required=false) @Valid @NotNull FlightsModelInput resource, UriComponentsBuilder uriComponentsBuilder) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            FlightsModelInput inputModel = resource != null ? resource : new FlightsModelInput();
            ProcessInstance pi = this.process.createInstance(businessKey, (Object)inputModel.toModel());
            List startFromNode = httpHeaders.get((Object)"X-KOGITO-StartFromNode");
            if (startFromNode != null && !startFromNode.isEmpty()) {
                pi.startFrom((String)startFromNode.get(0));
            } else {
                pi.start();
            }
            UriComponents uriComponents = uriComponentsBuilder.path("/flights/{id}").buildAndExpand(new Object[]{pi.id()});
            URI location = uriComponents.toUri();
            return ResponseEntity.created((URI)location).body((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        });
    }

    @GetMapping(produces={"application/json"})
    public List<FlightsModelOutput> getResources_flights() {
        return this.process.instances().values().stream().map(pi -> ((FlightsModel)pi.variables()).toOutput()).collect(Collectors.toList());
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public ResponseEntity<FlightsModelOutput> getResource_flights(@PathVariable(value="id") String id) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(m -> ResponseEntity.ok((Object)((FlightsModel)m.variables()).toOutput())).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @DeleteMapping(value={"/{id}"}, produces={"application/json"})
    public ResponseEntity<FlightsModelOutput> deleteResource_flights(@PathVariable(value="id") String id) {
        return ((Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.abort();
            return ((FlightsModel)pi.checkError().variables()).toOutput();
        }).map(m -> ResponseEntity.ok((Object)m)))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PutMapping(value={"/{id}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> updateModel_flights(@PathVariable(value="id") String id, @RequestBody(required=false) FlightsModel resource) {
        return ((Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ((FlightsModel)pi.updateVariables((Object)resource)).toOutput()).map(m -> ResponseEntity.ok((Object)m)))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/{id}/tasks"}, produces={"application/json"})
    public ResponseEntity<List<TaskModel>> getTasks_flights(@PathVariable(value="id") String id, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(Policies.of((String)user, (Collection)groups)).stream().map(Flights_TaskModelFactory::from).collect(Collectors.toList())).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping(value={"/{id}/solvingTerminated"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> signal_0(@PathVariable(value="id") String id, @RequestBody(required=false) Flight data) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.send(Sig.of((String)"solvingTerminated", (Object)data));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/newPassengerRequest"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> signal_1(@PathVariable(value="id") String id, @RequestBody(required=false) PassengerDTO data) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.send(Sig.of((String)"newPassengerRequest", (Object)data));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/New_Best_Solution"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> signal_2(@PathVariable(value="id") String id) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.send(Sig.of((String)"New Best Solution", null));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/newSolution"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> signal_3(@PathVariable(value="id") String id, @RequestBody(required=false) Flight data) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.send(Sig.of((String)"newSolution", (Object)data));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/Passenger_Boarding_Request"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> signal_4(@PathVariable(value="id") String id) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.send(Sig.of((String)"Passenger Boarding Request", null));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/finalizeSeatAssignment/{taskId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> taskTransition_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Flights_6_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PutMapping(value={"/{id}/finalizeSeatAssignment/{taskId}"}, consumes={"application/json"})
    public ResponseEntity<Flights_6_TaskOutput> saveTask_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Flights_6_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ResponseEntity.ok((Object)Flights_6_TaskOutput.fromMap((Map)((Map)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateContent((KogitoWorkItem)wi, (MapOutput)model), Policies.of((String)user, (Collection)groups)))))).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/phases/{phase}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> completeTask_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="phase") String phase, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups, @RequestBody(required=false) Flights_6_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/comments"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> addComment_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String commentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            Comment comment = (Comment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.addComment((KogitoWorkItem)wi, (String)commentInfo, (String)user), Policies.of((String)user, (Collection)groups));
            return ResponseEntity.created((URI)uriComponentsBuilder.path("/flights/{id}/finalizeSeatAssignment/{taskId}/comments/{commentId}").buildAndExpand(new Object[]{id, taskId, comment.getId()}).toUri()).body((Object)comment);
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PutMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/comments/{commentId}"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> updateComment_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String comment) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ResponseEntity.ok((Object)((Comment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateComment((KogitoWorkItem)wi, (Object)commentId, (String)comment, (String)user), Policies.of((String)user, (Collection)groups))))).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @DeleteMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/comments/{commentId}"})
    public ResponseEntity deleteComment_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            boolean removed = (Boolean)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.deleteComment((KogitoWorkItem)wi, (Object)commentId, (String)user), Policies.of((String)user, (Collection)groups));
            return removed ? ResponseEntity.ok().build() : ResponseEntity.notFound().build();
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/attachments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> addAttachment_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachmentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            Attachment attachment = (Attachment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.addAttachment((KogitoWorkItem)wi, (AttachmentInfo)attachmentInfo, (String)user), Policies.of((String)user, (Collection)groups));
            return ResponseEntity.created((URI)uriComponentsBuilder.path("/flights/{id}/finalizeSeatAssignment/{taskId}/attachments/{attachmentId}").buildAndExpand(new Object[]{id, taskId, attachment.getId()}).toUri()).body((Object)attachment);
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PutMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/attachments/{attachmentId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> updateAttachment_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachment) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ResponseEntity.ok((Object)((Attachment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateAttachment((KogitoWorkItem)wi, (Object)attachmentId, (AttachmentInfo)attachment, (String)user), Policies.of((String)user, (Collection)groups))))).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @DeleteMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/attachments/{attachmentId}"})
    public ResponseEntity deleteAttachment_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            boolean removed = (Boolean)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.deleteAttachment((KogitoWorkItem)wi, (Object)attachmentId, (String)user), Policies.of((String)user, (Collection)groups));
            return (removed ? ResponseEntity.ok() : ResponseEntity.notFound()).build();
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @GetMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/attachments/{attachmentId}"}, produces={"application/json"})
    public ResponseEntity<Attachment> getAttachment_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        Attachment attachment;
        Optional pi = this.process.instances().findById(id);
        if (pi.isPresent() && (attachment = (Attachment)HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getAttachments().get(attachmentId)) != null) {
            return ResponseEntity.ok((Object)attachment);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/attachments"}, produces={"application/json"})
    public ResponseEntity<Collection<Attachment>> getAttachments_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups) {
        Optional pi = this.process.instances().findById(id);
        return pi.isPresent() ? ResponseEntity.ok(HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getAttachments().values()) : ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/comments/{commentId}"}, produces={"application/json"})
    public ResponseEntity<Comment> getComment_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        Comment comment;
        Optional pi = this.process.instances().findById(id);
        if (pi.isPresent() && (comment = (Comment)HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getComments().get(commentId)) != null) {
            return ResponseEntity.ok((Object)comment);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/comments"}, produces={"application/json"})
    public ResponseEntity<Collection<Comment>> getComments_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        Optional pi = this.process.instances().findById(id);
        return pi.isPresent() ? ResponseEntity.ok(HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getComments().values()) : ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/finalizeSeatAssignment/{taskId}"}, produces={"application/json"})
    public ResponseEntity<Flights_6_TaskModel> getTask_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.process.instances().findById(id).map(pi -> Flights_6_TaskModel.from((WorkItem)pi.workItem(taskId, Policies.of((String)user, (Collection)groups)))).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"finalizeSeatAssignment/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_finalizeSeatAssignment_5() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"finalizeSeatAssignment");
    }

    @GetMapping(value={"/{id}/finalizeSeatAssignment/{taskId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)taskId, (Policy[])Policies.of((String)user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"finalizeSeatAssignment"));
    }

    @DeleteMapping(value={"/{id}/finalizeSeatAssignment/{taskId}"}, produces={"application/json"})
    public ResponseEntity<FlightsModelOutput> abortTask_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/finalizePassengerList/{taskId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> taskTransition_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Flights_7_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PutMapping(value={"/{id}/finalizePassengerList/{taskId}"}, consumes={"application/json"})
    public ResponseEntity<Flights_7_TaskOutput> saveTask_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Flights_7_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ResponseEntity.ok((Object)Flights_7_TaskOutput.fromMap((Map)((Map)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateContent((KogitoWorkItem)wi, (MapOutput)model), Policies.of((String)user, (Collection)groups)))))).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/finalizePassengerList/{taskId}/phases/{phase}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> completeTask_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="phase") String phase, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups, @RequestBody(required=false) Flights_7_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/finalizePassengerList/{taskId}/comments"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> addComment_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String commentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            Comment comment = (Comment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.addComment((KogitoWorkItem)wi, (String)commentInfo, (String)user), Policies.of((String)user, (Collection)groups));
            return ResponseEntity.created((URI)uriComponentsBuilder.path("/flights/{id}/finalizePassengerList/{taskId}/comments/{commentId}").buildAndExpand(new Object[]{id, taskId, comment.getId()}).toUri()).body((Object)comment);
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PutMapping(value={"/{id}/finalizePassengerList/{taskId}/comments/{commentId}"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> updateComment_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String comment) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ResponseEntity.ok((Object)((Comment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateComment((KogitoWorkItem)wi, (Object)commentId, (String)comment, (String)user), Policies.of((String)user, (Collection)groups))))).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @DeleteMapping(value={"/{id}/finalizePassengerList/{taskId}/comments/{commentId}"})
    public ResponseEntity deleteComment_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            boolean removed = (Boolean)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.deleteComment((KogitoWorkItem)wi, (Object)commentId, (String)user), Policies.of((String)user, (Collection)groups));
            return removed ? ResponseEntity.ok().build() : ResponseEntity.notFound().build();
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/finalizePassengerList/{taskId}/attachments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> addAttachment_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachmentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            Attachment attachment = (Attachment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.addAttachment((KogitoWorkItem)wi, (AttachmentInfo)attachmentInfo, (String)user), Policies.of((String)user, (Collection)groups));
            return ResponseEntity.created((URI)uriComponentsBuilder.path("/flights/{id}/finalizePassengerList/{taskId}/attachments/{attachmentId}").buildAndExpand(new Object[]{id, taskId, attachment.getId()}).toUri()).body((Object)attachment);
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PutMapping(value={"/{id}/finalizePassengerList/{taskId}/attachments/{attachmentId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> updateAttachment_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachment) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ResponseEntity.ok((Object)((Attachment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateAttachment((KogitoWorkItem)wi, (Object)attachmentId, (AttachmentInfo)attachment, (String)user), Policies.of((String)user, (Collection)groups))))).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @DeleteMapping(value={"/{id}/finalizePassengerList/{taskId}/attachments/{attachmentId}"})
    public ResponseEntity deleteAttachment_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            boolean removed = (Boolean)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.deleteAttachment((KogitoWorkItem)wi, (Object)attachmentId, (String)user), Policies.of((String)user, (Collection)groups));
            return (removed ? ResponseEntity.ok() : ResponseEntity.notFound()).build();
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @GetMapping(value={"/{id}/finalizePassengerList/{taskId}/attachments/{attachmentId}"}, produces={"application/json"})
    public ResponseEntity<Attachment> getAttachment_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        Attachment attachment;
        Optional pi = this.process.instances().findById(id);
        if (pi.isPresent() && (attachment = (Attachment)HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getAttachments().get(attachmentId)) != null) {
            return ResponseEntity.ok((Object)attachment);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/finalizePassengerList/{taskId}/attachments"}, produces={"application/json"})
    public ResponseEntity<Collection<Attachment>> getAttachments_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups) {
        Optional pi = this.process.instances().findById(id);
        return pi.isPresent() ? ResponseEntity.ok(HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getAttachments().values()) : ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/finalizePassengerList/{taskId}/comments/{commentId}"}, produces={"application/json"})
    public ResponseEntity<Comment> getComment_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        Comment comment;
        Optional pi = this.process.instances().findById(id);
        if (pi.isPresent() && (comment = (Comment)HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getComments().get(commentId)) != null) {
            return ResponseEntity.ok((Object)comment);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/finalizePassengerList/{taskId}/comments"}, produces={"application/json"})
    public ResponseEntity<Collection<Comment>> getComments_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        Optional pi = this.process.instances().findById(id);
        return pi.isPresent() ? ResponseEntity.ok(HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getComments().values()) : ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/finalizePassengerList/{taskId}"}, produces={"application/json"})
    public ResponseEntity<Flights_7_TaskModel> getTask_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.process.instances().findById(id).map(pi -> Flights_7_TaskModel.from((WorkItem)pi.workItem(taskId, Policies.of((String)user, (Collection)groups)))).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"finalizePassengerList/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_finalizePassengerList_6() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"finalizePassengerList");
    }

    @GetMapping(value={"/{id}/finalizePassengerList/{taskId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)taskId, (Policy[])Policies.of((String)user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"finalizePassengerList"));
    }

    @DeleteMapping(value={"/{id}/finalizePassengerList/{taskId}"}, produces={"application/json"})
    public ResponseEntity<FlightsModelOutput> abortTask_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/approveDenyPassenger/{taskId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> taskTransition_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Flights_18_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PutMapping(value={"/{id}/approveDenyPassenger/{taskId}"}, consumes={"application/json"})
    public ResponseEntity<Flights_18_TaskOutput> saveTask_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Flights_18_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ResponseEntity.ok((Object)Flights_18_TaskOutput.fromMap((Map)((Map)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateContent((KogitoWorkItem)wi, (MapOutput)model), Policies.of((String)user, (Collection)groups)))))).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/approveDenyPassenger/{taskId}/phases/{phase}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> completeTask_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="phase") String phase, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups, @RequestBody(required=false) Flights_18_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/approveDenyPassenger/{taskId}/comments"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> addComment_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String commentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            Comment comment = (Comment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.addComment((KogitoWorkItem)wi, (String)commentInfo, (String)user), Policies.of((String)user, (Collection)groups));
            return ResponseEntity.created((URI)uriComponentsBuilder.path("/flights/{id}/approveDenyPassenger/{taskId}/comments/{commentId}").buildAndExpand(new Object[]{id, taskId, comment.getId()}).toUri()).body((Object)comment);
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PutMapping(value={"/{id}/approveDenyPassenger/{taskId}/comments/{commentId}"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> updateComment_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String comment) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ResponseEntity.ok((Object)((Comment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateComment((KogitoWorkItem)wi, (Object)commentId, (String)comment, (String)user), Policies.of((String)user, (Collection)groups))))).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @DeleteMapping(value={"/{id}/approveDenyPassenger/{taskId}/comments/{commentId}"})
    public ResponseEntity deleteComment_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            boolean removed = (Boolean)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.deleteComment((KogitoWorkItem)wi, (Object)commentId, (String)user), Policies.of((String)user, (Collection)groups));
            return removed ? ResponseEntity.ok().build() : ResponseEntity.notFound().build();
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/approveDenyPassenger/{taskId}/attachments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> addAttachment_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachmentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            Attachment attachment = (Attachment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.addAttachment((KogitoWorkItem)wi, (AttachmentInfo)attachmentInfo, (String)user), Policies.of((String)user, (Collection)groups));
            return ResponseEntity.created((URI)uriComponentsBuilder.path("/flights/{id}/approveDenyPassenger/{taskId}/attachments/{attachmentId}").buildAndExpand(new Object[]{id, taskId, attachment.getId()}).toUri()).body((Object)attachment);
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PutMapping(value={"/{id}/approveDenyPassenger/{taskId}/attachments/{attachmentId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> updateAttachment_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachment) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ResponseEntity.ok((Object)((Attachment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateAttachment((KogitoWorkItem)wi, (Object)attachmentId, (AttachmentInfo)attachment, (String)user), Policies.of((String)user, (Collection)groups))))).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @DeleteMapping(value={"/{id}/approveDenyPassenger/{taskId}/attachments/{attachmentId}"})
    public ResponseEntity deleteAttachment_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            boolean removed = (Boolean)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.deleteAttachment((KogitoWorkItem)wi, (Object)attachmentId, (String)user), Policies.of((String)user, (Collection)groups));
            return (removed ? ResponseEntity.ok() : ResponseEntity.notFound()).build();
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @GetMapping(value={"/{id}/approveDenyPassenger/{taskId}/attachments/{attachmentId}"}, produces={"application/json"})
    public ResponseEntity<Attachment> getAttachment_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        Attachment attachment;
        Optional pi = this.process.instances().findById(id);
        if (pi.isPresent() && (attachment = (Attachment)HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getAttachments().get(attachmentId)) != null) {
            return ResponseEntity.ok((Object)attachment);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/approveDenyPassenger/{taskId}/attachments"}, produces={"application/json"})
    public ResponseEntity<Collection<Attachment>> getAttachments_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups) {
        Optional pi = this.process.instances().findById(id);
        return pi.isPresent() ? ResponseEntity.ok(HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getAttachments().values()) : ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/approveDenyPassenger/{taskId}/comments/{commentId}"}, produces={"application/json"})
    public ResponseEntity<Comment> getComment_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        Comment comment;
        Optional pi = this.process.instances().findById(id);
        if (pi.isPresent() && (comment = (Comment)HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getComments().get(commentId)) != null) {
            return ResponseEntity.ok((Object)comment);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/approveDenyPassenger/{taskId}/comments"}, produces={"application/json"})
    public ResponseEntity<Collection<Comment>> getComments_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        Optional pi = this.process.instances().findById(id);
        return pi.isPresent() ? ResponseEntity.ok(HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getComments().values()) : ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/approveDenyPassenger/{taskId}"}, produces={"application/json"})
    public ResponseEntity<Flights_18_TaskModel> getTask_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.process.instances().findById(id).map(pi -> Flights_18_TaskModel.from((WorkItem)pi.workItem(taskId, Policies.of((String)user, (Collection)groups)))).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"approveDenyPassenger/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_approveDenyPassenger_7() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"approveDenyPassenger");
    }

    @GetMapping(value={"/{id}/approveDenyPassenger/{taskId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)taskId, (Policy[])Policies.of((String)user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"approveDenyPassenger"));
    }

    @DeleteMapping(value={"/{id}/approveDenyPassenger/{taskId}"}, produces={"application/json"})
    public ResponseEntity<FlightsModelOutput> abortTask_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }
}

