/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.examples;

import java.util.Map;
import java.util.HashMap;
import org.kie.kogito.MappableToModel;
import org.kie.kogito.Model;

@org.kie.kogito.codegen.Generated(value = "kogito-codegen", reference = "flights", name = "Flights", hidden = false)
public class FlightsModel implements Model, MappableToModel<FlightsModelOutput> {

    private String id;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> params = new HashMap<>();
        params.put("flight", this.flight);
        params.put("isSolving", this.isSolving);
        params.put("processId", this.processId);
        params.put("params", this.params);
        params.put("isPassengerListFinalized", this.isPassengerListFinalized);
        return params;
    }

    @Override
    public FlightsModel fromMap(Map<String, Object> params) {
        return fromMap(null, params);
    }

    @Override
    public void update(Map<String, Object> params) {
        fromMap(getId(), params);
    }

    public FlightsModel fromMap(String id, Map<String, Object> params) {
        this.id = id;
        this.flight = (org.kie.kogito.examples.domain.Flight) params.get("flight");
        this.isSolving = (java.lang.Boolean) params.get("isSolving");
        this.processId = (java.lang.String) params.get("processId");
        this.params = (org.kie.kogito.examples.domain.FlightDTO) params.get("params");
        this.isPassengerListFinalized = (java.lang.Boolean) params.get("isPassengerListFinalized");
        return this;
    }

    @org.kie.kogito.codegen.VariableInfo(tags = "")
    @com.fasterxml.jackson.annotation.JsonProperty(value = "flight")
    @javax.validation.Valid()
    private org.kie.kogito.examples.domain.Flight flight;

    public org.kie.kogito.examples.domain.Flight getFlight() {
        return flight;
    }

    public void setFlight(org.kie.kogito.examples.domain.Flight flight) {
        this.flight = flight;
    }

    @org.kie.kogito.codegen.VariableInfo(tags = "")
    @com.fasterxml.jackson.annotation.JsonProperty(value = "isSolving")
    @javax.validation.Valid()
    private java.lang.Boolean isSolving;

    public java.lang.Boolean getIsSolving() {
        return isSolving;
    }

    public void setIsSolving(java.lang.Boolean isSolving) {
        this.isSolving = isSolving;
    }

    @org.kie.kogito.codegen.VariableInfo(tags = "")
    @com.fasterxml.jackson.annotation.JsonProperty(value = "processId")
    @javax.validation.Valid()
    private java.lang.String processId;

    public java.lang.String getProcessId() {
        return processId;
    }

    public void setProcessId(java.lang.String processId) {
        this.processId = processId;
    }

    @org.kie.kogito.codegen.VariableInfo(tags = "")
    @com.fasterxml.jackson.annotation.JsonProperty(value = "params")
    @javax.validation.Valid()
    private org.kie.kogito.examples.domain.FlightDTO params;

    public org.kie.kogito.examples.domain.FlightDTO getParams() {
        return params;
    }

    public void setParams(org.kie.kogito.examples.domain.FlightDTO params) {
        this.params = params;
    }

    @org.kie.kogito.codegen.VariableInfo(tags = "")
    @com.fasterxml.jackson.annotation.JsonProperty(value = "isPassengerListFinalized")
    @javax.validation.Valid()
    private java.lang.Boolean isPassengerListFinalized;

    public java.lang.Boolean getIsPassengerListFinalized() {
        return isPassengerListFinalized;
    }

    public void setIsPassengerListFinalized(java.lang.Boolean isPassengerListFinalized) {
        this.isPassengerListFinalized = isPassengerListFinalized;
    }

    @Override()
    public FlightsModelOutput toModel() {
        FlightsModelOutput result = new FlightsModelOutput();
        result.setId(getId());
        result.setFlight(getFlight());
        result.setIsSolving(getIsSolving());
        result.setProcessId(getProcessId());
        result.setParams(getParams());
        result.setIsPassengerListFinalized(getIsPassengerListFinalized());
        return result;
    }
}
