/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import io.quarkus.test.junit.QuarkusTest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.examples.demo.Person;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.identity.StaticIdentityProvider;

@QuarkusTest
public class PersonProcessTest {
    @Inject
    @Named(value="persons")
    Process<? extends Model> personProcess;
    private SecurityPolicy policy = SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("admin", Collections.singletonList("managers")));

    @Test
    public void testAdult() {
        Model m = (Model)this.personProcess.createModel();
        HashMap<String, Person> parameters = new HashMap<String, Person>();
        parameters.put("person", new Person("John Doe", 20));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.personProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)1, (int)result.toMap().size());
        Assertions.assertTrue((boolean)((Person)result.toMap().get("person")).isAdult());
    }

    @Test
    public void testChild() {
        Model m = (Model)this.personProcess.createModel();
        HashMap<String, Person> parameters = new HashMap<String, Person>();
        parameters.put("person", new Person("Jenny Quark", 14));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.personProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)1, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)1, (int)result.toMap().size());
        Assertions.assertFalse((boolean)((Person)result.toMap().get("person")).isAdult());
        List workItems = processInstance.workItems(new Policy[]{this.policy});
        Assertions.assertEquals((int)1, (int)workItems.size());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[]{this.policy});
        Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testChildWithSecurityPolicy() {
        Model m = (Model)this.personProcess.createModel();
        HashMap<String, Person> parameters = new HashMap<String, Person>();
        parameters.put("person", new Person("Jenny Quark", 14));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.personProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)1, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)1, (int)result.toMap().size());
        Assertions.assertFalse((boolean)((Person)result.toMap().get("person")).isAdult());
        List workItems = processInstance.workItems(new Policy[]{this.policy});
        Assertions.assertEquals((int)1, (int)workItems.size());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[]{this.policy});
        Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testChildWithSecurityPolicyNotAuthorized() {
        Model m = (Model)this.personProcess.createModel();
        HashMap<String, Person> parameters = new HashMap<String, Person>();
        parameters.put("person", new Person("Jenny Quark", 14));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.personProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)1, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)1, (int)result.toMap().size());
        Assertions.assertFalse((boolean)((Person)result.toMap().get("person")).isAdult());
        SecurityPolicy johnPolicy = SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"));
        List workItems = processInstance.workItems(new Policy[]{johnPolicy});
        Assertions.assertEquals((int)0, (int)workItems.size());
        processInstance.abort();
        Assertions.assertEquals((int)3, (int)processInstance.status());
    }
}

