/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.CoreMatchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;

@QuarkusTest
public class PersonsRestTest {
    @Inject
    @Named(value="persons")
    Process<? extends Model> personProcess;

    @BeforeEach
    public void setup() {
        this.personProcess.instances().values().forEach(pi -> pi.abort());
    }

    @Test
    public void testAdultPersonsRest() {
        Assertions.assertNotNull(this.personProcess);
        String addPersonPayload = "{\"person\" : {\"name\" : \"John Doe\", \"age\" : 20}}";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addPersonPayload).when().post("/persons", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[]{"person.adult", CoreMatchers.is((Object)true)})).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testChildPersonsRest() {
        Assertions.assertNotNull(this.personProcess);
        String addPersonPayload = "{\"person\" : {\"name\" : \"Jane Doe\", \"age\" : 16}}";
        String firstCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addPersonPayload).when().post("/persons", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)firstCreatedId)});
        Map taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons/" + firstCreatedId + "/tasks?user=admin", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)1, (int)taskInfo.size());
        taskInfo.containsValue("ChildrenHandling");
        String fixedOrderPayload = "{}";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskInfo.keySet().iterator().next() + "?user=admin", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testChildPersonsRestWithSecurityPolicy() {
        Assertions.assertNotNull(this.personProcess);
        String addPersonPayload = "{\"person\" : {\"name\" : \"Jane Doe\", \"age\" : 16}}";
        String firstCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addPersonPayload).when().post("/persons", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)firstCreatedId)});
        Map taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons/" + firstCreatedId + "/tasks?user=admin", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)1, (int)taskInfo.size());
        taskInfo.containsValue("ChildrenHandling");
        String fixedOrderPayload = "{}";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskInfo.keySet().iterator().next() + "?user=admin", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testChildPersonsRestWithSecurityPolicyNotAuthorized() {
        Assertions.assertNotNull(this.personProcess);
        String addPersonPayload = "{\"person\" : {\"name\" : \"Jane Doe\", \"age\" : 16}}";
        String firstCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addPersonPayload).when().post("/persons", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)firstCreatedId)});
        Map taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons/" + firstCreatedId + "/tasks?user=john", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)0, (int)taskInfo.size());
        taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons/" + firstCreatedId + "/tasks?user=admin", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)1, (int)taskInfo.size());
        taskInfo.containsValue("ChildrenHandling");
        String fixedOrderPayload = "{}";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskInfo.keySet().iterator().next() + "?user=john", new Object[0])).then()).statusCode(403);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskInfo.keySet().iterator().next() + "?user=admin", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testChildPersonsRestWithSecurityPolicyAndLifeCycles() {
        Assertions.assertNotNull(this.personProcess);
        String addPersonPayload = "{\"person\" : {\"name\" : \"Jane Doe\", \"age\" : 16}}";
        String firstCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addPersonPayload).when().post("/persons", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)firstCreatedId)});
        Map taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons/" + firstCreatedId + "/tasks?user=admin", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)1, (int)taskInfo.size());
        taskInfo.containsValue("ChildrenHandling");
        String taskId = (String)taskInfo.keySet().iterator().next();
        String fixedOrderPayload = "{}";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskId + "?phase=claim&user=admin", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskId + "?phase=release&user=admin", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskId + "?phase=skip&user=admin", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testPersonsRestStartFromUserTask() {
        Assertions.assertNotNull(this.personProcess);
        String addPersonPayload = "{\"person\" : {\"name\" : \"Jane Doe\", \"age\" : 30}}";
        String firstCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).header("X-KOGITO-StartFromNode", (Object)"UserTask_1", new Object[0]).body(addPersonPayload).when().post("/persons", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[]{"person.adult", CoreMatchers.is((Object)false)})).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)firstCreatedId), "[0].person.adult", CoreMatchers.is((Object)false)});
        Map taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons/" + firstCreatedId + "/tasks?user=admin", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)1, (int)taskInfo.size());
        taskInfo.containsValue("ChildrenHandling");
        String fixedOrderPayload = "{}";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskInfo.keySet().iterator().next() + "?user=admin", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testChildPersonsRestAbortViaMgmtInterface() {
        Assertions.assertNotNull(this.personProcess);
        String addPersonPayload = "{\"person\" : {\"name\" : \"Jane Doe\", \"age\" : 16}}";
        String firstCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addPersonPayload).when().post("/persons", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[]{"person.adult", CoreMatchers.is((Object)false)})).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)firstCreatedId), "[0].person.adult", CoreMatchers.is((Object)false)});
        Map taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons/" + firstCreatedId + "/tasks?user=admin", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)1, (int)taskInfo.size());
        taskInfo.containsValue("ChildrenHandling");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).when().delete("/management/processes/persons/instances/" + firstCreatedId, new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testChildPersonsRestRetriggerNodeViaMgmtInterface() {
        Assertions.assertNotNull(this.personProcess);
        String addPersonPayload = "{\"person\" : {\"name\" : \"Jane Doe\", \"age\" : 16}}";
        String firstCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addPersonPayload).when().post("/persons", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[]{"person.adult", CoreMatchers.is((Object)false)})).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)firstCreatedId), "[0].person.adult", CoreMatchers.is((Object)false)});
        Map taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons/" + firstCreatedId + "/tasks?user=admin", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)1, (int)taskInfo.size());
        taskInfo.containsValue("ChildrenHandling");
        String nodeInstanceId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).when().get("/management/processes/persons/instances/" + firstCreatedId + "/nodeInstances", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[0])).extract().path("[0].nodeInstanceId", new String[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).when().post("/management/processes/persons/instances/" + firstCreatedId + "/nodeInstances/" + nodeInstanceId, new Object[0])).then()).statusCode(200);
        taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons/" + firstCreatedId + "/tasks?user=admin", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        String retriggeredNodeInstanceId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).when().get("/management/processes/persons/instances/" + firstCreatedId + "/nodeInstances", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[0])).extract().path("[0].nodeInstanceId", new String[0]);
        Assertions.assertNotEquals((Object)nodeInstanceId, (Object)retriggeredNodeInstanceId);
        String fixedOrderPayload = "{}";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskInfo.keySet().iterator().next() + "?user=admin", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testChildPersonsRestCancelAndTriggerNodeViaMgmtInterface() {
        Assertions.assertNotNull(this.personProcess);
        String addPersonPayload = "{\"person\" : {\"name\" : \"Jane Doe\", \"age\" : 16}}";
        String firstCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addPersonPayload).when().post("/persons", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[]{"person.adult", CoreMatchers.is((Object)false)})).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)firstCreatedId), "[0].person.adult", CoreMatchers.is((Object)false)});
        Map taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons/" + firstCreatedId + "/tasks?user=admin", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)1, (int)taskInfo.size());
        taskInfo.containsValue("ChildrenHandling");
        String nodeInstanceId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).when().get("/management/processes/persons/instances/" + firstCreatedId + "/nodeInstances", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[0])).extract().path("[0].nodeInstanceId", new String[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).when().delete("/management/processes/persons/instances/" + firstCreatedId + "/nodeInstances/" + nodeInstanceId, new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).when().post("/management/processes/persons/instances/" + firstCreatedId + "/nodes/UserTask_1", new Object[0])).then()).statusCode(200);
        taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons/" + firstCreatedId + "/tasks?user=admin", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        String retriggeredNodeInstanceId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).when().get("/management/processes/persons/instances/" + firstCreatedId + "/nodeInstances", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[0])).extract().path("[0].nodeInstanceId", new String[0]);
        Assertions.assertNotEquals((Object)nodeInstanceId, (Object)retriggeredNodeInstanceId);
        String fixedOrderPayload = "{}";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskInfo.keySet().iterator().next() + "?user=admin", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }
}

