/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.CoreMatchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.testcontainers.quarkus.InfinispanQuarkusTestResource;
import org.kie.kogito.testcontainers.quarkus.KafkaQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource.List(value={@QuarkusTestResource(value=InfinispanQuarkusTestResource.Conditional.class), @QuarkusTestResource(value=KafkaQuarkusTestResource.Conditional.class)})
public class OrdersRestIT {
    @Inject
    @Named(value="demo.orders")
    Process<? extends Model> orderProcess;
    @Inject
    @Named(value="demo.orderItems")
    Process<? extends Model> orderItemsProcess;

    @BeforeEach
    public void cleanUp() {
        this.orderProcess.instances().values(ProcessInstanceReadMode.MUTABLE).forEach(pi -> pi.abort());
        this.orderItemsProcess.instances().values(ProcessInstanceReadMode.MUTABLE).forEach(pi -> pi.abort());
    }

    @Test
    public void testOrdersRest() {
        Assertions.assertNotNull(this.orderProcess);
        String addOrderPayload = "{\"approver\" : \"john\", \"order\" : {\"orderNumber\" : \"12345\", \"shipped\" : false}}";
        String firstCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addOrderPayload).when().post("/orders", new Object[0])).then()).statusCode(201)).header("Location", CoreMatchers.notNullValue())).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orders", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)firstCreatedId)});
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orders/{id}", new Object[]{firstCreatedId})).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        String secondCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addOrderPayload).when().post("/orders", new Object[0])).then()).statusCode(201)).extract().path("id", new String[0]);
        ((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().delete("/orders/{id}", new Object[]{firstCreatedId})).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orders", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)secondCreatedId)});
        ((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().delete("/orders/{id}", new Object[]{secondCreatedId})).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orders", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testOrdersWithErrorRest() {
        Assertions.assertNotNull(this.orderProcess);
        String addOrderPayload = "{\"order\" : {\"orderNumber\" : \"12345\", \"shipped\" : false}}";
        String firstCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addOrderPayload).when().post("/orders", new Object[0])).then()).statusCode(500)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orders", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)firstCreatedId)});
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/management/processes/demo.orders/instances/" + firstCreatedId + "/error", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        String fixedOrderPayload = "{\"approver\" : \"john\", \"order\" : {\"orderNumber\" : \"12345\", \"shipped\" : false}}";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().put("/orders/" + firstCreatedId, new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0])).body("approver", CoreMatchers.equalTo((Object)"john"), new Object[0])).body("order.orderNumber", CoreMatchers.equalTo((Object)"12345"), new Object[0])).body("order.shipped", CoreMatchers.equalTo((Object)false), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().post("/management/processes/demo.orders/instances/" + firstCreatedId + "/retrigger", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().delete("/orders/" + firstCreatedId, new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orders", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testOrdersWithOrderItemsRest() {
        Assertions.assertNotNull(this.orderProcess);
        String addOrderPayload = "{\"approver\" : \"john\", \"order\" : {\"orderNumber\" : \"12345\", \"shipped\" : false}}";
        String firstCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addOrderPayload).when().post("/orders", new Object[0])).then()).statusCode(201)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orders", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)firstCreatedId)});
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orders/" + firstCreatedId, new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        String orderItemsId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orderItems", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[0])).extract().path("[0].id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orderItems/" + orderItemsId, new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)orderItemsId), new Object[0]);
        String taskId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orderItems/" + orderItemsId + "/tasks?user=john", new Object[0])).then()).statusCode(200)).body("$.size", CoreMatchers.is((Object)1), new Object[0])).body("[0].name", CoreMatchers.is((Object)"Verify order"), new Object[0])).extract().path("[0].id", new String[0]);
        String payload = "{}";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(payload).when().post("/orderItems/" + orderItemsId + "/Verify_order/" + taskId + "?user=john", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)orderItemsId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orders", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orderItems", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testOrdersWithOrderItemsAbortedRest() {
        Assertions.assertNotNull(this.orderProcess);
        String addOrderPayload = "{\"approver\" : \"john\", \"order\" : {\"orderNumber\" : \"12345\", \"shipped\" : false}}";
        String firstCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addOrderPayload).when().post("/orders", new Object[0])).then()).statusCode(201)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orders", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)firstCreatedId)});
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orders/" + firstCreatedId, new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        String orderItemsId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orderItems?businessKey=ORD-0001", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[0])).extract().path("[0].id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orderItems/" + orderItemsId, new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)orderItemsId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orderItems/" + orderItemsId + "/tasks?user=john", new Object[0])).then()).statusCode(200)).body("$.size", CoreMatchers.is((Object)1), new Object[0])).body("[0].name", CoreMatchers.is((Object)"Verify order"), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().delete("/orderItems/" + orderItemsId, new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orders", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orderItems", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testCreateAndUpdateOrders() {
        String orderPayload = "{\"approver\" : \"john\", \"order\" : {\"orderNumber\" : \"12345\", \"shipped\" : false}}";
        String id = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(orderPayload).when().post("/orders", new Object[0])).then()).statusCode(201)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        Assertions.assertNotNull((Object)id);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orders", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).body(orderPayload).when().get("/orders/{id}", new Object[]{id})).then()).statusCode(200)).body("id", CoreMatchers.is((Object)id), new Object[0]);
        orderPayload = "{\"approver\" : \"joe\", \"order\" : {\"orderNumber\" : \"54321\", \"shipped\" : true}}";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(orderPayload).when().put("/orders/{id}", new Object[]{id})).then()).statusCode(200)).body("approver", CoreMatchers.equalTo((Object)"joe"), new Object[0])).body("order.orderNumber", CoreMatchers.equalTo((Object)"54321"), new Object[0])).body("order.shipped", CoreMatchers.equalTo((Object)true), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orders", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().delete("/orders/{id}", new Object[]{id})).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/orders", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }
}

