/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.examples.demo.Order;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.testcontainers.quarkus.InfinispanQuarkusTestResource;
import org.kie.kogito.testcontainers.quarkus.KafkaQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource.List(value={@QuarkusTestResource(value=InfinispanQuarkusTestResource.Conditional.class), @QuarkusTestResource(value=KafkaQuarkusTestResource.Conditional.class)})
public class OrdersProcessIT {
    @Inject
    @Named(value="demo.orders")
    Process<? extends Model> orderProcess;
    @Inject
    @Named(value="demo.orderItems")
    Process<? extends Model> orderItemsProcess;
    private SecurityPolicy policy = SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john", Collections.singletonList("managers")));

    @BeforeEach
    public void setup() {
        this.orderProcess.instances().values(ProcessInstanceReadMode.MUTABLE).forEach(pi -> pi.abort());
        this.orderItemsProcess.instances().values(ProcessInstanceReadMode.MUTABLE).forEach(pi -> pi.abort());
    }

    @Test
    public void testOrderProcess() {
        Assertions.assertNotNull(this.orderProcess);
        Model m = (Model)this.orderProcess.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("approver", "john");
        parameters.put("order", (String)new Order("12345", Boolean.valueOf(false), Double.valueOf(0.0)));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.orderProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)1, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)2, (int)result.toMap().size());
        Assertions.assertTrue((((Order)result.toMap().get("order")).getTotal() > 0.0 ? 1 : 0) != 0);
        ProcessInstances orderItemProcesses = this.orderItemsProcess.instances();
        Assertions.assertEquals((int)1, (Integer)orderItemProcesses.size());
        ProcessInstance childProcessInstance = (ProcessInstance)orderItemProcesses.values(ProcessInstanceReadMode.MUTABLE).iterator().next();
        List workItems = childProcessInstance.workItems(new Policy[]{this.policy});
        Assertions.assertEquals((int)1, (int)workItems.size());
        childProcessInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[]{this.policy});
        Assertions.assertEquals((int)2, (int)childProcessInstance.status());
        Optional pi = this.orderProcess.instances().findById(processInstance.id());
        Assertions.assertFalse((boolean)pi.isPresent());
        Assertions.assertEquals((int)0, (Integer)this.orderProcess.instances().size());
        Assertions.assertEquals((int)0, (Integer)this.orderItemsProcess.instances().size());
    }

    @Test
    public void testOrderProcessWithError() {
        Assertions.assertNotNull(this.orderProcess);
        Model m = (Model)this.orderProcess.createModel();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("order", new Order("12345", Boolean.valueOf(false), Double.valueOf(0.0)));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.orderProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)5, (int)processInstance.status());
        Assertions.assertTrue((boolean)processInstance.error().isPresent());
        parameters = new HashMap();
        parameters.put("approver", "john");
        parameters.put("order", new Order("12345", Boolean.valueOf(false), Double.valueOf(0.0)));
        m.fromMap(parameters);
        processInstance.updateVariables((Object)m);
        ((ProcessError)processInstance.error().get()).retrigger();
        Assertions.assertEquals((int)1, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)2, (int)result.toMap().size());
        Assertions.assertTrue((((Order)result.toMap().get("order")).getTotal() > 0.0 ? 1 : 0) != 0);
        ProcessInstances orderItemProcesses = this.orderItemsProcess.instances();
        Assertions.assertEquals((int)1, (Integer)orderItemProcesses.size());
        ProcessInstance childProcessInstance = (ProcessInstance)orderItemProcesses.values(ProcessInstanceReadMode.MUTABLE).iterator().next();
        List workItems = childProcessInstance.workItems(new Policy[]{this.policy});
        Assertions.assertEquals((int)1, (int)workItems.size());
        childProcessInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[]{this.policy});
        Assertions.assertEquals((int)2, (int)childProcessInstance.status());
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Assertions.assertEquals((int)0, (Integer)this.orderProcess.instances().size());
        Assertions.assertEquals((int)0, (Integer)this.orderItemsProcess.instances().size());
    }
}

