/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels.quarkus;

import io.quarkus.test.junit.QuarkusTest;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;

@QuarkusTest
public class MultiParamServiceProcessTest {
    @Named(value="multiparams")
    @Inject
    Process<? extends Model> multiparamsProcess;

    @Test
    public void testServiceWithMultipleParams() {
        Assertions.assertNotNull(this.multiparamsProcess);
        Model m = (Model)this.multiparamsProcess.createModel();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("name", "john");
        parameters.put("age", 44);
        m.fromMap(parameters);
        ProcessInstance processInstance = this.multiparamsProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)2, (int)result.toMap().size());
    }
}

