/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.jackson.JsonCloudEventData;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.acme.QueryRequest;
import org.acme.QueryRequestRepository;
import org.acme.ResolveRequest;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="query-service")
@ApplicationScoped
public class QueryServiceResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryServiceResource.class);
    private static final String RESPONSE_EVENTS = "response_events";
    @Inject
    QueryRequestRepository repository;
    @Inject
    @Channel(value="response_events")
    Emitter<String> eventsEmitter;
    @Inject
    ObjectMapper objectMapper;

    @GET
    @Produces(value={"application/json"})
    public List<QueryRequest> get() {
        return this.repository.getAll();
    }

    @Path(value="sendQuery")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response sendQuery(QueryRequest request) {
        LOGGER.debug("Query request received: {}", (Object)request);
        this.repository.saveOrUpdate(request);
        return Response.ok((Object)"{}").build();
    }

    @Path(value="resolveQuery")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response resolveQuery(ResolveRequest request) {
        String event = this.generateCloudEvent(request.getProcessInstanceId(), request.getQueryResponse());
        LOGGER.debug("Resolving query for processInstanceId:{}, event to send is: {}", (Object)request.getProcessInstanceId(), (Object)event);
        this.eventsEmitter.send((Object)event);
        this.repository.delete(request.getProcessInstanceId());
        return Response.ok((Object)"{}").build();
    }

    public String generateCloudEvent(String processInstanceId, String queryResponse) {
        try {
            return this.objectMapper.writeValueAsString((Object)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(UUID.randomUUID().toString()).withSource(URI.create("")).withType("query_response_events").withTime(OffsetDateTime.now()).withExtension("kogitoprocrefid", processInstanceId)).withData((CloudEventData)JsonCloudEventData.wrap((JsonNode)this.objectMapper.createObjectNode().put("answer", queryResponse)))).build());
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

