/*
 * Decompiled with CFR 0.152.
 */
package org.acme.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.acme.QueryRequest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.quarkus.PostgreSqlQuarkusTestResource;

@QuarkusTestResource(value=PostgreSqlQuarkusTestResource.Conditional.class)
@QuarkusIntegrationTest
class QueryServiceResourceIT {
    private static final String QUERY_SERVICE_URL = "/query-service";
    private static final String PROCESS_INSTANCE_ID = "PROCESS_INSTANCE_ID";
    private static final String QUERY = "THE QUERY TO ANSWER";
    private static final String RESPONSE = "THE RESPONSE TO SEND";

    QueryServiceResourceIT() {
    }

    @Test
    void queryProcessCycle() {
        String queryRequestJson = "{\"processInstanceId\": \"PROCESS_INSTANCE_ID\",\"query\": \"THE QUERY TO ANSWER\"}";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(queryRequestJson).post("/query-service/sendQuery", new Object[0])).then()).statusCode(200);
        List<QueryRequest> queryRequests = this.getCurrentRequests();
        Assertions.assertThat(queryRequests).hasSize(1);
        QueryRequest queryRequest = queryRequests.get(0);
        Assertions.assertThat((String)queryRequest.getProcessInstanceId()).isEqualTo(PROCESS_INSTANCE_ID);
        Assertions.assertThat((String)queryRequest.getQuery()).isEqualTo(QUERY);
        String resolveRequestJson = "{\"processInstanceId\": \"PROCESS_INSTANCE_ID\",\"queryResponse\": \"THE RESPONSE TO SEND\"}";
        String resolveQueryPath = "/query-service/resolveQuery";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(resolveRequestJson).post(resolveQueryPath, new Object[0])).then()).statusCode(200);
        queryRequests = this.getCurrentRequests();
        Assertions.assertThat(queryRequests).isEmpty();
    }

    private List<QueryRequest> getCurrentRequests() {
        JsonPath currentRequests = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).get(QUERY_SERVICE_URL, new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
        return currentRequests.getList("", QueryRequest.class);
    }
}

