/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import io.quarkus.arc.DefaultBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.acme.QueryRequest;
import org.acme.QueryRequestRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultBean
@ApplicationScoped
public class InMemoryQueryRequestRepository
implements QueryRequestRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryQueryRequestRepository.class);
    private final Map<String, QueryRequest> queryRequestMap = new ConcurrentHashMap<String, QueryRequest>();

    @PostConstruct
    public void init() {
        LOGGER.info("The {} repository will be used. You can build the application with the persistence profile to use a PostgreSQL database. Read the project documentation for more information.", (Object)InMemoryQueryRequestRepository.class.getName());
    }

    @Override
    public void saveOrUpdate(QueryRequest queryRequest) {
        this.queryRequestMap.put(queryRequest.getProcessInstanceId(), queryRequest);
    }

    @Override
    public void delete(String id) {
        this.queryRequestMap.remove(id);
    }

    @Override
    public List<QueryRequest> getAll() {
        return new ArrayList<QueryRequest>(this.queryRequestMap.values());
    }
}

