/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import io.quarkus.arc.properties.IfBuildProperty;
import io.quarkus.runtime.Startup;
import io.vertx.mutiny.pgclient.PgPool;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowIterator;
import io.vertx.mutiny.sqlclient.RowSet;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.acme.QueryRequest;
import org.acme.QueryRequestRepository;
import org.acme.QueryServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Startup
@IfBuildProperty(name="quarkus.datasource.db-kind", stringValue="postgresql")
public class PostgreSqlQueryRequestRepository
implements QueryRequestRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgreSqlQueryRequestRepository.class);
    private static final String QUERY_REQUEST_TABLE = "queryrequest";
    private static final String CREATE_QUERY_REQUEST_TABLE = "CREATE TABLE IF NOT EXISTS public.queryrequest\n(\n    processinstanceid character varying NOT NULL,\n    query character varying,\n    CONSTRAINT queryrequest_pkey PRIMARY KEY (processinstanceid)\n)";
    private static final String QUERY_REQUEST_COLUMNS = "processinstanceid, query";
    @Inject
    PgPool client;

    @PostConstruct
    public void initDB() {
        try {
            LOGGER.debug("Initializing {} table.", (Object)QUERY_REQUEST_TABLE);
            this.client.query(CREATE_QUERY_REQUEST_TABLE).execute().await().indefinitely();
        }
        catch (Exception e) {
            throw new QueryServiceException("An error was produced during queryrequest initialization: " + e.getMessage(), e);
        }
    }

    @Override
    public void saveOrUpdate(QueryRequest queryRequest) {
        ((RowSet)this.client.preparedQuery("INSERT INTO queryrequest (processinstanceid, query)  VALUES ($1, $2) ON CONFLICT (processinstanceid) DO UPDATE SET query = $2 RETURNING processinstanceid, query").execute(Tuple.tuple(Stream.of(queryRequest.getProcessInstanceId(), queryRequest.getQuery()).collect(Collectors.toList()))).await().indefinitely()).value();
    }

    @Override
    public void delete(String id) {
        this.client.preparedQuery("DELETE FROM queryrequest WHERE processinstanceid = $1").execute(Tuple.of((Object)id)).await().indefinitely();
    }

    @Override
    public List<QueryRequest> getAll() {
        RowIterator rows = (RowIterator)this.client.query("SELECT processinstanceid, query FROM queryrequest").execute().onItem().transform(RowSet::iterator).await().indefinitely();
        return StreamSupport.stream(((Iterable)() -> rows).spliterator(), false).map(PostgreSqlQueryRequestRepository::from).collect(Collectors.toList());
    }

    private static QueryRequest from(Row row) {
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setProcessInstanceId(row.getString("processinstanceid"));
        queryRequest.setQuery(row.getString("query"));
        return queryRequest;
    }
}

