/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.queries.Applicant;
import org.kie.kogito.queries.LoanApplication;
import org.kie.kogito.queries.LoanUnitDTO;
import org.kie.kogito.queries.LoanUnitQueryFindApprovedEndpoint;
import org.kie.kogito.queries.LoanUnitQueryFindNotApprovedIdAndAmountEndpoint;
import org.kie.kogito.queries.LoanUnitRuleUnit;
import org.kie.kogito.rules.RuleUnit;

public class QueryTest {
    @Test
    public void testApproved() {
        LoanUnitQueryFindApprovedEndpoint query = new LoanUnitQueryFindApprovedEndpoint((RuleUnit)new LoanUnitRuleUnit());
        List results = query.executeQuery(this.createLoanUnitDTO()).stream().map(LoanApplication::getId).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertTrue((boolean)results.containsAll(Arrays.asList("ABC0001", "ABC0005")));
    }

    @Test
    public void testNotApproved() {
        LoanUnitQueryFindNotApprovedIdAndAmountEndpoint query = new LoanUnitQueryFindNotApprovedIdAndAmountEndpoint((RuleUnit)new LoanUnitRuleUnit());
        List results = query.executeQuery(this.createLoanUnitDTO());
        Assertions.assertEquals((int)3, (int)results.size());
        Collections.sort(results, (r1, r2) -> r1.get$id().compareTo(r2.get$id()));
        Assertions.assertEquals((Object)"ABC0002", (Object)((LoanUnitQueryFindNotApprovedIdAndAmountEndpoint.Result)results.get(0)).get$id());
        Assertions.assertEquals((int)1500, (int)((LoanUnitQueryFindNotApprovedIdAndAmountEndpoint.Result)results.get(0)).get$amount());
        Assertions.assertEquals((Object)"ABC0003", (Object)((LoanUnitQueryFindNotApprovedIdAndAmountEndpoint.Result)results.get(1)).get$id());
        Assertions.assertEquals((int)4000, (int)((LoanUnitQueryFindNotApprovedIdAndAmountEndpoint.Result)results.get(1)).get$amount());
        Assertions.assertEquals((Object)"ABC0004", (Object)((LoanUnitQueryFindNotApprovedIdAndAmountEndpoint.Result)results.get(2)).get$id());
        Assertions.assertEquals((int)8000, (int)((LoanUnitQueryFindNotApprovedIdAndAmountEndpoint.Result)results.get(2)).get$amount());
    }

    private LoanUnitDTO createLoanUnitDTO() {
        ArrayList<LoanApplication> loanApplications = new ArrayList<LoanApplication>();
        loanApplications.add(new LoanApplication("ABC0001", new Applicant("John", 45), 3000, 1200));
        loanApplications.add(new LoanApplication("ABC0002", new Applicant("Paul", 15), 1500, 500));
        loanApplications.add(new LoanApplication("ABC0003", new Applicant("Mary", 28), 4000, 300));
        loanApplications.add(new LoanApplication("ABC0004", new Applicant("George", 35), 8000, 3000));
        loanApplications.add(new LoanApplication("ABC0005", new Applicant("Lucy", 22), 1600, 200));
        LoanUnitDTO loanUnitDto = new LoanUnitDTO();
        loanUnitDto.setMaxAmount(5000);
        loanUnitDto.setLoanApplications(loanApplications);
        return loanUnitDto;
    }
}

