/*
 * Decompiled with CFR 0.152.
 */
package org.drools.project.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.drools.core.SessionConfigurationImpl;
import org.drools.core.config.DefaultRuleEventListenerConfig;
import org.drools.core.config.StaticRuleConfig;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.drools.project.model.ProjectModel;
import org.kie.api.KieBase;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.kogito.rules.KieRuntimeBuilder;
import org.kie.kogito.rules.RuleConfig;
import org.kie.kogito.rules.RuleEventListenerConfig;

@ApplicationScoped
public class ProjectRuntime
implements KieRuntimeBuilder {
    private final ProjectModel model = new ProjectModel();
    private final Map<String, KieBase> kbases = new HashMap<String, KieBase>();

    public KieBase getKieBase() {
        return this.getKieBase("defaultKieBase");
    }

    public KieBase getKieBase(String name) {
        return this.kbases.computeIfAbsent(name, n -> KieBaseBuilder.createKieBaseFromModel(this.model.getModelsForKieBase((String)n), (KieBaseModel)((KieBaseModel)this.model.getKieModuleModel().getKieBaseModels().get(n))));
    }

    public KieSession newKieSession() {
        return this.newKieSession("defaultKieSession");
    }

    public KieSession newKieSession(String sessionName) {
        return this.newKieSession(sessionName, (RuleConfig)new StaticRuleConfig((RuleEventListenerConfig)new DefaultRuleEventListenerConfig()));
    }

    public KieSession newKieSession(String sessionName, RuleConfig ruleConfig) {
        return Optional.ofNullable(this.getKieBaseForSession(sessionName).newKieSession(this.getConfForSession(sessionName), null)).map(k -> {
            ruleConfig.ruleEventListeners().agendaListeners().forEach(arg_0 -> ((KieSession)k).addEventListener(arg_0));
            ruleConfig.ruleEventListeners().ruleRuntimeListeners().forEach(arg_0 -> ((KieSession)k).addEventListener(arg_0));
            return k;
        }).get();
    }

    private KieBase getKieBaseForSession(String sessionName) {
        switch (sessionName) {
            case "defaultStatelessKieSession": {
                return this.getKieBase("defaultKieBase");
            }
            case "defaultKieSession": {
                return this.getKieBase("defaultKieBase");
            }
            case "org$kie$kogito$queries$LoanUnitKieSession": {
                return this.getKieBase("org$kie$kogito$queries$LoanUnitKieBase");
            }
        }
        return null;
    }

    private KieSessionConfiguration getConfForSession(String sessionName) {
        SessionConfigurationImpl conf = new SessionConfigurationImpl();
        switch (sessionName) {
            case "defaultStatelessKieSession": {
                conf.setOption((KieSessionOption)ClockTypeOption.get((String)"realtime"));
                break;
            }
            case "defaultKieSession": {
                conf.setOption((KieSessionOption)ClockTypeOption.get((String)"realtime"));
                break;
            }
            case "org$kie$kogito$queries$LoanUnitKieSession": {
                conf.setOption((KieSessionOption)ClockTypeOption.get((String)"realtime"));
            }
        }
        return conf;
    }
}

