/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.drools.project.model.ProjectRuntime;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.Config;
import org.kie.kogito.event.EventPublisher;
import org.kie.kogito.queries.LoanUnitRuleUnit;
import org.kie.kogito.rules.KieRuntimeBuilder;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.units.impl.AbstractRuleUnits;
import org.kie.kogito.uow.UnitOfWorkManager;

@Singleton
public class Application
implements org.kie.kogito.Application {
    @Inject
    Instance<EventPublisher> eventPublishers;
    @ConfigProperty(name="kogito.service.url")
    Optional<String> kogitoService;
    @Inject
    Config config;
    RuleUnits ruleUnits = new RuleUnits();

    public Config config() {
        return this.config;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return this.config().process().unitOfWorkManager();
    }

    @PostConstruct
    public void setup() {
        if (this.config().process() != null) {
            if (this.eventPublishers != null) {
                this.eventPublishers.forEach(publisher -> this.unitOfWorkManager().eventManager().addPublisher(publisher));
            }
            this.unitOfWorkManager().eventManager().setService(this.kogitoService.orElse(""));
            this.unitOfWorkManager().eventManager().setAddons(this.config().addons());
        }
    }

    public RuleUnits ruleUnits() {
        return this.ruleUnits;
    }

    public class RuleUnits
    extends AbstractRuleUnits {
        KieRuntimeBuilder ruleRuntimeBuilder = new ProjectRuntime();

        public KieRuntimeBuilder ruleRuntimeBuilder() {
            return this.ruleRuntimeBuilder;
        }

        protected RuleUnit<?> create(String fqcn) {
            switch (fqcn) {
                case "org.kie.kogito.queries.LoanUnit": {
                    return new LoanUnitRuleUnit(Application.this);
                }
            }
            throw new UnsupportedOperationException();
        }
    }
}

