package org.kie.kogito.queries;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitInstance;
import static java.util.stream.Collectors.toList;

@Path("/find-not-approved-id-and-amount")
public class LoanUnitQueryFindNotApprovedIdAndAmountEndpoint {

    @org.springframework.beans.factory.annotation.Autowired()
    RuleUnit<org.kie.kogito.queries.LoanUnit> ruleUnit;

    public LoanUnitQueryFindNotApprovedIdAndAmountEndpoint() {
    }

    public LoanUnitQueryFindNotApprovedIdAndAmountEndpoint(RuleUnit<org.kie.kogito.queries.LoanUnit> ruleUnit) {
        this.ruleUnit = ruleUnit;
    }

    @POST()
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    public List<Result> executeQuery(org.kie.kogito.queries.LoanUnit unitDTO) {
        RuleUnitInstance<org.kie.kogito.queries.LoanUnit> instance = ruleUnit.createInstance(unitDTO);
        List<Result> response = instance.executeQuery("FindNotApprovedIdAndAmount").stream().map(this::toResult).collect(toList());
        return response;
    }

    @POST()
    @Path("/first")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    public Result executeQueryFirst(org.kie.kogito.queries.LoanUnit unitDTO) {
        List<Result> results = executeQuery(unitDTO);
        Result response = results.isEmpty() ? null : results.get(0);
        return response;
    }

    private Result toResult(Map<String, Object> tuple) {
        return new Result((Integer) tuple.get("$amount"), (java.lang.String) tuple.get("$id"));
    }

    public static class Result {

        public Result(int $amount, String $id) {
            this.$amount = $amount;
            this.$id = $id;
        }

        private final int $amount;

        public int get$amount() {
            return $amount;
        }

        private final String $id;

        public String get$id() {
            return $id;
        }
    }
}
