/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.kie.kogito.explainability.api.ModelIdentifierDto;
import org.kie.kogito.tracing.typedvalue.TypedValue;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExplainabilityRequestDto {
    @JsonProperty(value="executionId")
    @NotNull(message="executionId must be provided.")
    private @NotNull(message="executionId must be provided.") String executionId;
    @JsonProperty(value="serviceUrl")
    @NotBlank(message="serviceUrl is mandatory.")
    private @NotBlank(message="serviceUrl is mandatory.") String serviceUrl;
    @JsonProperty(value="modelIdentifier")
    @NotNull(message="modelIdentifier object must be provided.")
    @Valid
    private @NotNull(message="modelIdentifier object must be provided.") @Valid ModelIdentifierDto modelIdentifier;
    @JsonProperty(value="inputs")
    private Map<String, TypedValue> inputs;
    @JsonProperty(value="outputs")
    private Map<String, TypedValue> outputs;

    private ExplainabilityRequestDto() {
    }

    public ExplainabilityRequestDto(String executionId, String serviceUrl, ModelIdentifierDto modelIdentifier, Map<String, TypedValue> inputs, Map<String, TypedValue> outputs) {
        this.executionId = executionId;
        this.serviceUrl = serviceUrl;
        this.modelIdentifier = modelIdentifier;
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public ModelIdentifierDto getModelIdentifier() {
        return this.modelIdentifier;
    }

    public Map<String, TypedValue> getInputs() {
        return this.inputs;
    }

    public Map<String, TypedValue> getOutputs() {
        return this.outputs;
    }
}

