/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.kie.kogito.explainability.api.ExplainabilityStatus;
import org.kie.kogito.explainability.api.SaliencyDto;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExplainabilityResultDto {
    @JsonProperty(value="executionId")
    private String executionId;
    @JsonProperty(value="status")
    private ExplainabilityStatus status;
    @JsonProperty(value="statusDetails")
    private String statusDetails;
    @JsonProperty(value="saliency")
    private Map<String, SaliencyDto> saliencies;

    private ExplainabilityResultDto() {
    }

    private ExplainabilityResultDto(String executionId, ExplainabilityStatus status, String statusDetails, Map<String, SaliencyDto> saliencies) {
        this.executionId = executionId;
        this.status = status;
        this.statusDetails = statusDetails;
        this.saliencies = saliencies;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public ExplainabilityStatus getStatus() {
        return this.status;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public Map<String, SaliencyDto> getSaliencies() {
        return this.saliencies;
    }

    public static ExplainabilityResultDto buildSucceeded(String executionId, Map<String, SaliencyDto> saliencies) {
        return new ExplainabilityResultDto(executionId, ExplainabilityStatus.SUCCEEDED, null, saliencies);
    }

    public static ExplainabilityResultDto buildFailed(String executionId, String statusDetails) {
        return new ExplainabilityResultDto(executionId, ExplainabilityStatus.FAILED, statusDetails, null);
    }
}

