/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Collections;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.api.BaseExplainabilityResult;
import org.kie.kogito.explainability.api.LIMEExplainabilityRequest;
import org.kie.kogito.explainability.api.ModelIdentifier;

@QuarkusTest
class ExplainabilityApiV1IT {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String executionId = UUID.randomUUID().toString();
    private static final String serviceUrl = "http://localhost:8080";

    ExplainabilityApiV1IT() {
    }

    @Test
    void testEndpointWithRequest() throws JsonProcessingException {
        ModelIdentifier modelIdentifier = new ModelIdentifier("dmn", "namespace:name");
        String body = MAPPER.writeValueAsString((Object)new LIMEExplainabilityRequest(executionId, serviceUrl, modelIdentifier, Collections.emptyList(), Collections.emptyList()));
        BaseExplainabilityResult result = (BaseExplainabilityResult)((Response)RestAssured.given().contentType(ContentType.JSON).body(body).when().post("/v1/explain", new Object[0])).as(BaseExplainabilityResult.class);
        Assertions.assertEquals((Object)executionId, (Object)result.getExecutionId());
    }

    @Test
    void testEndpointWithBadRequests() throws JsonProcessingException {
        LIMEExplainabilityRequest[] badRequests = new LIMEExplainabilityRequest[]{new LIMEExplainabilityRequest(executionId, serviceUrl, new ModelIdentifier("", "test"), Collections.emptyList(), Collections.emptyList()), new LIMEExplainabilityRequest(executionId, serviceUrl, new ModelIdentifier("test", ""), Collections.emptyList(), Collections.emptyList()), new LIMEExplainabilityRequest(executionId, "", new ModelIdentifier("test", "test"), Collections.emptyList(), Collections.emptyList())};
        for (int i = 0; i < badRequests.length; ++i) {
            String body = MAPPER.writeValueAsString((Object)badRequests[i]);
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(body).when().post("/v1/explain", new Object[0])).then()).statusCode(400);
        }
    }
}

