/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.api.ExplainabilityRequestDto;
import org.kie.kogito.explainability.api.ExplainabilityResultDto;
import org.kie.kogito.explainability.api.ModelIdentifierDto;

@QuarkusTest
class ExplainabilityApiV1Test {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String executionId = "test";
    private static final String serviceUrl = "http://localhost:8080";

    ExplainabilityApiV1Test() {
    }

    @Test
    void testEndpointWithRequest() throws JsonProcessingException {
        ModelIdentifierDto modelIdentifierDto = new ModelIdentifierDto("dmn", "namespace:name");
        String body = MAPPER.writeValueAsString((Object)new ExplainabilityRequestDto(executionId, serviceUrl, modelIdentifierDto, Collections.emptyMap(), Collections.emptyMap()));
        ExplainabilityResultDto result = (ExplainabilityResultDto)((Response)RestAssured.given().contentType(ContentType.JSON).body(body).when().post("/v1/explain", new Object[0])).as(ExplainabilityResultDto.class);
        Assertions.assertEquals((Object)executionId, (Object)result.getExecutionId());
    }

    @Test
    void testEndpointWithBadRequests() throws JsonProcessingException {
        ExplainabilityRequestDto[] badRequests = new ExplainabilityRequestDto[]{new ExplainabilityRequestDto(null, serviceUrl, new ModelIdentifierDto(executionId, executionId), Collections.emptyMap(), Collections.emptyMap()), new ExplainabilityRequestDto(executionId, serviceUrl, new ModelIdentifierDto("", executionId), Collections.emptyMap(), Collections.emptyMap()), new ExplainabilityRequestDto(executionId, serviceUrl, new ModelIdentifierDto(executionId, ""), Collections.emptyMap(), Collections.emptyMap()), new ExplainabilityRequestDto(executionId, serviceUrl, null, Collections.emptyMap(), Collections.emptyMap()), new ExplainabilityRequestDto(executionId, "", new ModelIdentifierDto(executionId, executionId), Collections.emptyMap(), Collections.emptyMap()), new ExplainabilityRequestDto(executionId, null, new ModelIdentifierDto(executionId, executionId), Collections.emptyMap(), Collections.emptyMap()), new ExplainabilityRequestDto(null, null, null, Collections.emptyMap(), Collections.emptyMap())};
        for (int i = 0; i < badRequests.length; ++i) {
            String body = MAPPER.writeValueAsString((Object)badRequests[i]);
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(body).when().post("/v1/explain", new Object[0])).then()).statusCode(400);
        }
    }
}

