package org.kie.flexible.kogito.example;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.Application;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.impl.Sig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.kie.flexible.kogito.example.ServiceDeskModelOutput;

@Path("/serviceDesk")
@org.springframework.stereotype.Component()
public class ServiceDeskResource {

    @org.springframework.beans.factory.annotation.Autowired()
    @org.springframework.beans.factory.annotation.Qualifier("serviceDesk")
    Process<ServiceDeskModel> process;

    @org.springframework.beans.factory.annotation.Autowired()
    Application application;

    @POST()
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput createResource_serviceDesk(@Context HttpHeaders httpHeaders, @QueryParam("businessKey") String businessKey, @javax.validation.Valid() @javax.validation.constraints.NotNull() ServiceDeskModelInput resource) {
        if (resource == null) {
            resource = new ServiceDeskModelInput();
        }
        final ServiceDeskModelInput value = resource;
        return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ProcessInstance<ServiceDeskModel> pi = process.createInstance(businessKey, mapInput(value, new ServiceDeskModel()));
            String startFromNode = httpHeaders.getHeaderString("X-KOGITO-StartFromNode");
            if (startFromNode != null) {
                pi.startFrom(startFromNode);
            } else {
                pi.start();
            }
            return getModel(pi);
        });
    }

    @GET()
    @Produces(MediaType.APPLICATION_JSON)
    public List<ServiceDeskModelOutput> getResources_serviceDesk() {
        return process.instances().values().stream().map(pi -> mapOutput(new ServiceDeskModelOutput(), pi.variables())).collect(Collectors.toList());
    }

    @GET()
    @Path("/{id}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput getResource_serviceDesk(@PathParam("id") String id) {
        return process.instances().findById(id).map(pi -> mapOutput(new ServiceDeskModelOutput(), pi.variables())).orElse(null);
    }

    @DELETE()
    @Path("/{id}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput deleteResource_serviceDesk(@PathParam("id") final String id) {
        return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            } else {
                pi.abort();
                return getModel(pi);
            }
        });
    }

    @POST()
    @Path("/{id}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput updateModel_serviceDesk(@PathParam("id") String id, ServiceDeskModel resource) {
        return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            } else {
                pi.updateVariables(resource);
                return mapOutput(new ServiceDeskModelOutput(), pi.variables());
            }
        });
    }

    @GET()
    @Path("/{id}/tasks")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, String> getTasks_serviceDesk(@PathParam("id") String id, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return process.instances().findById(id).map(pi -> pi.workItems(policies(user, groups))).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }

    protected ServiceDeskModelOutput getModel(ProcessInstance<ServiceDeskModel> pi) {
        if (pi.status() == ProcessInstance.STATE_ERROR && pi.error().isPresent()) {
            throw new ProcessInstanceExecutionException(pi.id(), pi.error().get().failedNodeId(), pi.error().get().errorMessage());
        }
        return mapOutput(new ServiceDeskModelOutput(), pi.variables());
    }

    protected Policy[] policies(String user, List<String> groups) {
        if (user == null) {
            return new Policy[0];
        }
        org.kie.kogito.auth.IdentityProvider identity = null;
        if (user != null) {
            identity = new org.kie.kogito.services.identity.StaticIdentityProvider(user, groups);
        }
        return new Policy[] { SecurityPolicy.of(identity) };
    }

    protected ServiceDeskModel mapInput(@javax.validation.Valid() @javax.validation.constraints.NotNull() ServiceDeskModelInput input, ServiceDeskModel resource) {
        resource.fromMap(input.toMap());
        return resource;
    }

    protected ServiceDeskModelOutput mapOutput(ServiceDeskModelOutput output, ServiceDeskModel resource) {
        output.fromMap(resource.getId(), resource.toMap());
        return output;
    }

    @POST
    @Path("/{id}/Resolve_Case")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public org.kie.flexible.kogito.example.ServiceDeskModelOutput signal_0(@PathParam("id") final String id) {
        return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.send(Sig.of("Resolve Case", null));
            return getModel(pi);
        });
    }

    @POST
    @Path("/{id}/CaseResolved")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public org.kie.flexible.kogito.example.ServiceDeskModelOutput signal_1(@PathParam("id") final String id) {
        return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.send(Sig.of("CaseResolved", null));
            return getModel(pi);
        });
    }

    @POST()
    @Path("/{id}/ManualAssignment/{workItemId}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput completeTask_ManualAssignment_2(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("complete") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups, final ServiceDesk_11_TaskOutput model) {
        try {
            return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
                ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                org.kie.kogito.auth.IdentityProvider identity = null;
                if (user != null) {
                    identity = new org.kie.kogito.services.identity.StaticIdentityProvider(user, groups);
                }
                org.jbpm.process.instance.impl.humantask.HumanTaskTransition transition = new org.jbpm.process.instance.impl.humantask.HumanTaskTransition(phase, model.toMap(), identity);
                pi.transitionWorkItem(workItemId, transition);
                return getModel(pi);
            });
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET()
    @Path("/{id}/ManualAssignment/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDesk_11_TaskInput getTask_ManualAssignment_2(@PathParam("id") String id, @PathParam("workItemId") String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        try {
            ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId, policies(user, groups));
            if (workItem == null) {
                return null;
            }
            return ServiceDesk_11_TaskInput.fromMap(workItem.getId(), workItem.getName(), workItem.getParameters());
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET()
    @Path("ManualAssignment/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchema_ManualAssignment_2() {
        return JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ManualAssignment");
    }

    @GET()
    @Path("/{id}/ManualAssignment/{workItemId}/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchemaAndPhases_ManualAssignment_2(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return JsonSchemaUtil.addPhases(process, application, id, workItemId, policies(user, groups), JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ManualAssignment"));
    }

    @DELETE()
    @Path("/{id}/ManualAssignment/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput abortTask_ManualAssignment_2(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("abort") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        try {
            return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
                ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                org.kie.kogito.auth.IdentityProvider identity = null;
                if (user != null) {
                    identity = new org.kie.kogito.services.identity.StaticIdentityProvider(user, groups);
                }
                org.jbpm.process.instance.impl.humantask.HumanTaskTransition transition = new org.jbpm.process.instance.impl.humantask.HumanTaskTransition(phase, null, identity);
                pi.transitionWorkItem(workItemId, transition);
                return getModel(pi);
            });
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @POST()
    @Path("/{id}/Questionnaire/{workItemId}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput completeTask_Questionnaire_3(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("complete") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups, final ServiceDesk_14_TaskOutput model) {
        try {
            return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
                ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                org.kie.kogito.auth.IdentityProvider identity = null;
                if (user != null) {
                    identity = new org.kie.kogito.services.identity.StaticIdentityProvider(user, groups);
                }
                org.jbpm.process.instance.impl.humantask.HumanTaskTransition transition = new org.jbpm.process.instance.impl.humantask.HumanTaskTransition(phase, model.toMap(), identity);
                pi.transitionWorkItem(workItemId, transition);
                return getModel(pi);
            });
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET()
    @Path("/{id}/Questionnaire/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDesk_14_TaskInput getTask_Questionnaire_3(@PathParam("id") String id, @PathParam("workItemId") String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        try {
            ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId, policies(user, groups));
            if (workItem == null) {
                return null;
            }
            return ServiceDesk_14_TaskInput.fromMap(workItem.getId(), workItem.getName(), workItem.getParameters());
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET()
    @Path("Questionnaire/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchema_Questionnaire_3() {
        return JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "Questionnaire");
    }

    @GET()
    @Path("/{id}/Questionnaire/{workItemId}/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchemaAndPhases_Questionnaire_3(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return JsonSchemaUtil.addPhases(process, application, id, workItemId, policies(user, groups), JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "Questionnaire"));
    }

    @DELETE()
    @Path("/{id}/Questionnaire/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput abortTask_Questionnaire_3(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("abort") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        try {
            return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
                ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                org.kie.kogito.auth.IdentityProvider identity = null;
                if (user != null) {
                    identity = new org.kie.kogito.services.identity.StaticIdentityProvider(user, groups);
                }
                org.jbpm.process.instance.impl.humantask.HumanTaskTransition transition = new org.jbpm.process.instance.impl.humantask.HumanTaskTransition(phase, null, identity);
                pi.transitionWorkItem(workItemId, transition);
                return getModel(pi);
            });
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @POST
    @Path("/{id}/ReceiveCustomerComment")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public javax.ws.rs.core.Response signal_ReceiveCustomerComment_4(@PathParam("id") final String id) {
        return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.send(Sig.of("Receive customer comment", java.util.Collections.emptyMap()));
            java.util.Optional<WorkItem> task = pi.workItems().stream().filter(wi -> wi.getName().equals("ReceiveCustomerComment")).findFirst();
            if (task.isPresent()) {
                return javax.ws.rs.core.Response.ok(getModel(pi)).header("Link", "</" + id + "/ReceiveCustomerComment/" + task.get().getId() + ">; rel='instance'").build();
            }
            return javax.ws.rs.core.Response.status(javax.ws.rs.core.Response.Status.NOT_FOUND).build();
        });
    }

    @POST()
    @Path("/{id}/ReceiveCustomerComment/{workItemId}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput completeTask_ReceiveCustomerComment_4(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("complete") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups, final ServiceDesk_16_TaskOutput model) {
        try {
            return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
                ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                org.kie.kogito.auth.IdentityProvider identity = null;
                if (user != null) {
                    identity = new org.kie.kogito.services.identity.StaticIdentityProvider(user, groups);
                }
                org.jbpm.process.instance.impl.humantask.HumanTaskTransition transition = new org.jbpm.process.instance.impl.humantask.HumanTaskTransition(phase, model.toMap(), identity);
                pi.transitionWorkItem(workItemId, transition);
                return getModel(pi);
            });
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET()
    @Path("/{id}/ReceiveCustomerComment/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDesk_16_TaskInput getTask_ReceiveCustomerComment_4(@PathParam("id") String id, @PathParam("workItemId") String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        try {
            ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId, policies(user, groups));
            if (workItem == null) {
                return null;
            }
            return ServiceDesk_16_TaskInput.fromMap(workItem.getId(), workItem.getName(), workItem.getParameters());
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET()
    @Path("ReceiveCustomerComment/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchema_ReceiveCustomerComment_4() {
        return JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ReceiveCustomerComment");
    }

    @GET()
    @Path("/{id}/ReceiveCustomerComment/{workItemId}/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchemaAndPhases_ReceiveCustomerComment_4(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return JsonSchemaUtil.addPhases(process, application, id, workItemId, policies(user, groups), JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ReceiveCustomerComment"));
    }

    @DELETE()
    @Path("/{id}/ReceiveCustomerComment/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput abortTask_ReceiveCustomerComment_4(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("abort") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        try {
            return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
                ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                org.kie.kogito.auth.IdentityProvider identity = null;
                if (user != null) {
                    identity = new org.kie.kogito.services.identity.StaticIdentityProvider(user, groups);
                }
                org.jbpm.process.instance.impl.humantask.HumanTaskTransition transition = new org.jbpm.process.instance.impl.humantask.HumanTaskTransition(phase, null, identity);
                pi.transitionWorkItem(workItemId, transition);
                return getModel(pi);
            });
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @POST
    @Path("/{id}/ReceiveSupportComment")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public javax.ws.rs.core.Response signal_ReceiveSupportComment_5(@PathParam("id") final String id) {
        return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.send(Sig.of("Receive support comment", java.util.Collections.emptyMap()));
            java.util.Optional<WorkItem> task = pi.workItems().stream().filter(wi -> wi.getName().equals("ReceiveSupportComment")).findFirst();
            if (task.isPresent()) {
                return javax.ws.rs.core.Response.ok(getModel(pi)).header("Link", "</" + id + "/ReceiveSupportComment/" + task.get().getId() + ">; rel='instance'").build();
            }
            return javax.ws.rs.core.Response.status(javax.ws.rs.core.Response.Status.NOT_FOUND).build();
        });
    }

    @POST()
    @Path("/{id}/ReceiveSupportComment/{workItemId}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput completeTask_ReceiveSupportComment_5(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("complete") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups, final ServiceDesk_17_TaskOutput model) {
        try {
            return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
                ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                org.kie.kogito.auth.IdentityProvider identity = null;
                if (user != null) {
                    identity = new org.kie.kogito.services.identity.StaticIdentityProvider(user, groups);
                }
                org.jbpm.process.instance.impl.humantask.HumanTaskTransition transition = new org.jbpm.process.instance.impl.humantask.HumanTaskTransition(phase, model.toMap(), identity);
                pi.transitionWorkItem(workItemId, transition);
                return getModel(pi);
            });
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET()
    @Path("/{id}/ReceiveSupportComment/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDesk_17_TaskInput getTask_ReceiveSupportComment_5(@PathParam("id") String id, @PathParam("workItemId") String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        try {
            ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId, policies(user, groups));
            if (workItem == null) {
                return null;
            }
            return ServiceDesk_17_TaskInput.fromMap(workItem.getId(), workItem.getName(), workItem.getParameters());
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET()
    @Path("ReceiveSupportComment/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchema_ReceiveSupportComment_5() {
        return JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ReceiveSupportComment");
    }

    @GET()
    @Path("/{id}/ReceiveSupportComment/{workItemId}/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchemaAndPhases_ReceiveSupportComment_5(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return JsonSchemaUtil.addPhases(process, application, id, workItemId, policies(user, groups), JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ReceiveSupportComment"));
    }

    @DELETE()
    @Path("/{id}/ReceiveSupportComment/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput abortTask_ReceiveSupportComment_5(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("abort") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        try {
            return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
                ProcessInstance<ServiceDeskModel> pi = process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                org.kie.kogito.auth.IdentityProvider identity = null;
                if (user != null) {
                    identity = new org.kie.kogito.services.identity.StaticIdentityProvider(user, groups);
                }
                org.jbpm.process.instance.impl.humantask.HumanTaskTransition transition = new org.jbpm.process.instance.impl.humantask.HumanTaskTransition(phase, null, identity);
                pi.transitionWorkItem(workItemId, transition);
                return getModel(pi);
            });
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }
}
