package org.kie.flexible.kogito.example;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.Application;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.ProcessInstanceNotFoundException;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policies;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.auth.IdentityProvider;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.kie.flexible.kogito.example.ServiceDeskModelOutput;

@Path("/serviceDesk")
@org.springframework.stereotype.Component()
public class ServiceDeskResource {

    @org.springframework.beans.factory.annotation.Autowired()
    @org.springframework.beans.factory.annotation.Qualifier("serviceDesk")
    Process<ServiceDeskModel> process;

    @org.springframework.beans.factory.annotation.Autowired()
    Application application;

    @POST
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    public Response createResource_serviceDesk(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @QueryParam("businessKey") String businessKey, @javax.validation.Valid() @javax.validation.constraints.NotNull() ServiceDeskModelInput resource) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ServiceDeskModelInput inputModel = resource != null ? resource : new ServiceDeskModelInput();
            ProcessInstance<ServiceDeskModel> pi = process.createInstance(businessKey, inputModel.toModel());
            String startFromNode = httpHeaders.getHeaderString("X-KOGITO-StartFromNode");
            if (startFromNode != null) {
                pi.startFrom(startFromNode);
            } else {
                pi.start();
            }
            UriBuilder uriBuilder = uriInfo.getAbsolutePathBuilder().path(pi.id());
            return Response.created(uriBuilder.build()).entity(pi.checkError().variables().toOutput()).build();
        });
    }

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public List<ServiceDeskModelOutput> getResources_serviceDesk() {
        return process.instances().values().stream().map(pi -> pi.variables().toOutput()).collect(Collectors.toList());
    }

    @GET
    @Path("/{id}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput getResource_serviceDesk(@PathParam("id") String id) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.variables().toOutput()).orElseThrow(() -> new NotFoundException());
    }

    @DELETE
    @Path("/{id}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput deleteResource_serviceDesk(@PathParam("id") final String id) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.abort();
            return pi.checkError().variables().toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @PUT
    @Path("/{id}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput updateModel_serviceDesk(@PathParam("id") String id, ServiceDeskModel resource) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> pi.updateVariables(resource).toOutput()).orElseThrow(() -> new NotFoundException()));
    }

    @GET
    @Path("/{id}/tasks")
    @Produces(MediaType.APPLICATION_JSON)
    public List<WorkItem> getTasks_serviceDesk(@PathParam("id") String id, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(Policies.of(user, groups))).orElseThrow(() -> new NotFoundException());
    }

    @POST
    @Path("/{id}/Resolve_Case")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public org.kie.flexible.kogito.example.ServiceDeskModelOutput signal_0(@PathParam("id") final String id) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            return process.instances().findById(id).map(pi -> {
                pi.send(Sig.of("Resolve Case", null));
                return pi.checkError().variables().toOutput();
            }).orElseThrow(() -> new NotFoundException());
        });
    }

    @POST
    @Path("/{id}/CaseResolved")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public org.kie.flexible.kogito.example.ServiceDeskModelOutput signal_1(@PathParam("id") final String id) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            return process.instances().findById(id).map(pi -> {
                pi.send(Sig.of("CaseResolved", null));
                return pi.checkError().variables().toOutput();
            }).orElseThrow(() -> new NotFoundException());
        });
    }

    @POST
    @Path("/{id}/ManualAssignment/{workItemId}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput completeTask_ManualAssignment_2(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("complete") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups, final ServiceDesk_11_TaskOutput model) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withModel(phase, model, Policies.of(user, groups)));
            return pi.variables().toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @GET
    @Path("/{id}/ManualAssignment/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDesk_11_TaskInput getTask_ManualAssignment_2(@PathParam("id") String id, @PathParam("workItemId") String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> ServiceDesk_11_TaskInput.from(pi.workItem(workItemId, Policies.of(user, groups)))).orElseThrow(() -> new NotFoundException());
    }

    @GET
    @Path("ManualAssignment/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchema_ManualAssignment_2() {
        return JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ManualAssignment");
    }

    @GET
    @Path("/{id}/ManualAssignment/{workItemId}/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchemaAndPhases_ManualAssignment_2(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return JsonSchemaUtil.addPhases(process, application, id, workItemId, Policies.of(user, groups), JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ManualAssignment"));
    }

    @DELETE
    @Path("/{id}/ManualAssignment/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput abortTask_ManualAssignment_2(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("abort") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withoutModel(phase, Policies.of(user, groups)));
            return pi.variables().toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @POST
    @Path("/{id}/Questionnaire/{workItemId}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput completeTask_Questionnaire_3(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("complete") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups, final ServiceDesk_14_TaskOutput model) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withModel(phase, model, Policies.of(user, groups)));
            return pi.variables().toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @GET
    @Path("/{id}/Questionnaire/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDesk_14_TaskInput getTask_Questionnaire_3(@PathParam("id") String id, @PathParam("workItemId") String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> ServiceDesk_14_TaskInput.from(pi.workItem(workItemId, Policies.of(user, groups)))).orElseThrow(() -> new NotFoundException());
    }

    @GET
    @Path("Questionnaire/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchema_Questionnaire_3() {
        return JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "Questionnaire");
    }

    @GET
    @Path("/{id}/Questionnaire/{workItemId}/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchemaAndPhases_Questionnaire_3(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return JsonSchemaUtil.addPhases(process, application, id, workItemId, Policies.of(user, groups), JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "Questionnaire"));
    }

    @DELETE
    @Path("/{id}/Questionnaire/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput abortTask_Questionnaire_3(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("abort") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withoutModel(phase, Policies.of(user, groups)));
            return pi.variables().toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @POST
    @Path("/{id}/ReceiveCustomerComment")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public Response signal_ReceiveCustomerComment_4(@PathParam("id") final String id, @Context UriInfo uriInfo) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            return process.instances().findById(id).map(pi -> {
                pi.send(Sig.of("Receive customer comment", java.util.Collections.emptyMap()));
                java.util.Optional<WorkItem> task = pi.workItems().stream().filter(wi -> wi.getName().equals("ReceiveCustomerComment")).findFirst();
                if (task.isPresent()) {
                    return Response.created(uriInfo.getAbsolutePathBuilder().path(task.get().getId()).build()).entity(pi.variables().toOutput()).build();
                }
                return Response.status(Response.Status.NOT_FOUND).build();
            }).orElseThrow(() -> new NotFoundException());
        });
    }

    @POST
    @Path("/{id}/ReceiveCustomerComment/{workItemId}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput completeTask_ReceiveCustomerComment_4(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("complete") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups, final ServiceDesk_16_TaskOutput model) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withModel(phase, model, Policies.of(user, groups)));
            return pi.variables().toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @GET
    @Path("/{id}/ReceiveCustomerComment/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDesk_16_TaskInput getTask_ReceiveCustomerComment_4(@PathParam("id") String id, @PathParam("workItemId") String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> ServiceDesk_16_TaskInput.from(pi.workItem(workItemId, Policies.of(user, groups)))).orElseThrow(() -> new NotFoundException());
    }

    @GET
    @Path("ReceiveCustomerComment/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchema_ReceiveCustomerComment_4() {
        return JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ReceiveCustomerComment");
    }

    @GET
    @Path("/{id}/ReceiveCustomerComment/{workItemId}/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchemaAndPhases_ReceiveCustomerComment_4(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return JsonSchemaUtil.addPhases(process, application, id, workItemId, Policies.of(user, groups), JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ReceiveCustomerComment"));
    }

    @DELETE
    @Path("/{id}/ReceiveCustomerComment/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput abortTask_ReceiveCustomerComment_4(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("abort") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withoutModel(phase, Policies.of(user, groups)));
            return pi.variables().toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @POST
    @Path("/{id}/ReceiveSupportComment")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public Response signal_ReceiveSupportComment_5(@PathParam("id") final String id, @Context UriInfo uriInfo) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            return process.instances().findById(id).map(pi -> {
                pi.send(Sig.of("Receive support comment", java.util.Collections.emptyMap()));
                java.util.Optional<WorkItem> task = pi.workItems().stream().filter(wi -> wi.getName().equals("ReceiveSupportComment")).findFirst();
                if (task.isPresent()) {
                    return Response.created(uriInfo.getAbsolutePathBuilder().path(task.get().getId()).build()).entity(pi.variables().toOutput()).build();
                }
                return Response.status(Response.Status.NOT_FOUND).build();
            }).orElseThrow(() -> new NotFoundException());
        });
    }

    @POST
    @Path("/{id}/ReceiveSupportComment/{workItemId}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput completeTask_ReceiveSupportComment_5(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("complete") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups, final ServiceDesk_17_TaskOutput model) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withModel(phase, model, Policies.of(user, groups)));
            return pi.variables().toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @GET
    @Path("/{id}/ReceiveSupportComment/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDesk_17_TaskInput getTask_ReceiveSupportComment_5(@PathParam("id") String id, @PathParam("workItemId") String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> ServiceDesk_17_TaskInput.from(pi.workItem(workItemId, Policies.of(user, groups)))).orElseThrow(() -> new NotFoundException());
    }

    @GET
    @Path("ReceiveSupportComment/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchema_ReceiveSupportComment_5() {
        return JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ReceiveSupportComment");
    }

    @GET
    @Path("/{id}/ReceiveSupportComment/{workItemId}/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchemaAndPhases_ReceiveSupportComment_5(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return JsonSchemaUtil.addPhases(process, application, id, workItemId, Policies.of(user, groups), JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ReceiveSupportComment"));
    }

    @DELETE
    @Path("/{id}/ReceiveSupportComment/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public ServiceDeskModelOutput abortTask_ReceiveSupportComment_5(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("abort") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withoutModel(phase, Policies.of(user, groups)));
            return pi.variables().toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }
}
