/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.flexible.kogito.example;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.Application;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policies;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.http.ResponseEntity;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.kie.flexible.kogito.example.ServiceDeskModelOutput;

@RestController
@RequestMapping("/serviceDesk")
@org.springframework.stereotype.Component()
public class ServiceDeskResource {

    @org.springframework.beans.factory.annotation.Autowired()
    @org.springframework.beans.factory.annotation.Qualifier("serviceDesk")
    Process<ServiceDeskModel> process;

    @org.springframework.beans.factory.annotation.Autowired()
    Application application;

    @PostMapping(produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDeskModelOutput> createResource_serviceDesk(@RequestHeader HttpHeaders httpHeaders, @RequestParam(value = "businessKey", required = false) String businessKey, @RequestBody(required = false) @javax.validation.Valid() @javax.validation.constraints.NotNull() ServiceDeskModelInput resource, UriComponentsBuilder uriComponentsBuilder) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ServiceDeskModelInput inputModel = resource != null ? resource : new ServiceDeskModelInput();
            ProcessInstance<ServiceDeskModel> pi = process.createInstance(businessKey, inputModel.toModel());
            List<String> startFromNode = httpHeaders.get("X-KOGITO-StartFromNode");
            if (startFromNode != null && !startFromNode.isEmpty()) {
                pi.startFrom(startFromNode.get(0));
            } else {
                pi.start();
            }
            UriComponents uriComponents = uriComponentsBuilder.path("/serviceDesk/{id}").buildAndExpand(pi.id());
            URI location = uriComponents.toUri();
            return ResponseEntity.created(location).body(pi.checkError().variables().toOutput());
        });
    }

    @GetMapping(produces = MediaType.APPLICATION_JSON_VALUE)
    public List<ServiceDeskModelOutput> getResources_serviceDesk() {
        return process.instances().values().stream().map(pi -> pi.variables().toOutput()).collect(Collectors.toList());
    }

    @GetMapping(value = "/{id}", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDeskModelOutput> getResource_serviceDesk(@PathVariable("id") String id) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(m -> ResponseEntity.ok(m.variables().toOutput())).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @DeleteMapping(value = "/{id}", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDeskModelOutput> deleteResource_serviceDesk(@PathVariable("id") final String id) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.abort();
            return pi.checkError().variables().toOutput();
        }).map(m -> ResponseEntity.ok(m))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PutMapping(value = "/{id}", produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDeskModelOutput> updateModel_serviceDesk(@PathVariable("id") String id, @RequestBody(required = false) ServiceDeskModel resource) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> pi.updateVariables(resource).toOutput()).map(m -> ResponseEntity.ok(m))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value = "/{id}/tasks", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<List<WorkItem>> getTasks_serviceDesk(@PathVariable("id") String id, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(Policies.of(user, groups))).map(m -> ResponseEntity.ok(m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping(value = "/{id}/Resolve_Case", produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<org.kie.flexible.kogito.example.ServiceDeskModelOutput> signal_0(@PathVariable("id") final String id) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            return process.instances().findById(id).map(pi -> {
                pi.send(Sig.of("Resolve Case", null));
                return ResponseEntity.ok(pi.checkError().variables().toOutput());
            }).orElseGet(() -> ResponseEntity.notFound().build());
        });
    }

    @PostMapping(value = "/{id}/CaseResolved", produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<org.kie.flexible.kogito.example.ServiceDeskModelOutput> signal_1(@PathVariable("id") final String id) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            return process.instances().findById(id).map(pi -> {
                pi.send(Sig.of("CaseResolved", null));
                return ResponseEntity.ok(pi.checkError().variables().toOutput());
            }).orElseGet(() -> ResponseEntity.notFound().build());
        });
    }

    @PostMapping(value = "/{id}/ManualAssignment/{workItemId}", produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDeskModelOutput> completeTask_ManualAssignment_2(@PathVariable("id") final String id, @PathVariable("workItemId") final String workItemId, @RequestParam(value = "phase", required = false, defaultValue = "complete") final String phase, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups, @RequestBody(required = false) final ServiceDesk_11_TaskOutput model) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withModel(phase, model, Policies.of(user, groups)));
            return ResponseEntity.ok(pi.checkError().variables().toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @GetMapping(value = "/{id}/ManualAssignment/{workItemId}", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDesk_11_TaskInput> getTask_ManualAssignment_2(@PathVariable("id") String id, @PathVariable("workItemId") String workItemId, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups) {
        return process.instances().findById(id).map(pi -> ServiceDesk_11_TaskInput.from(pi.workItem(workItemId, Policies.of(user, groups)))).map(m -> ResponseEntity.ok(m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value = "ManualAssignment/schema", produces = MediaType.APPLICATION_JSON_VALUE)
    public Map<String, Object> getSchema_ManualAssignment_2() {
        return JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ManualAssignment");
    }

    @GetMapping(value = "/{id}/ManualAssignment/{workItemId}/schema", produces = MediaType.APPLICATION_JSON_VALUE)
    public Map<String, Object> getSchemaAndPhases_ManualAssignment_2(@PathVariable("id") final String id, @PathVariable("workItemId") final String workItemId, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups) {
        return JsonSchemaUtil.addPhases(process, application, id, workItemId, Policies.of(user, groups), JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ManualAssignment"));
    }

    @DeleteMapping(value = "/{id}/ManualAssignment/{workItemId}", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDeskModelOutput> abortTask_ManualAssignment_2(@PathVariable("id") final String id, @PathVariable("workItemId") final String workItemId, @RequestParam(value = "phase", required = false, defaultValue = "abort") final String phase, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withoutModel(phase, Policies.of(user, groups)));
            return ResponseEntity.ok(pi.checkError().variables().toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value = "/{id}/Questionnaire/{workItemId}", produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDeskModelOutput> completeTask_Questionnaire_3(@PathVariable("id") final String id, @PathVariable("workItemId") final String workItemId, @RequestParam(value = "phase", required = false, defaultValue = "complete") final String phase, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups, @RequestBody(required = false) final ServiceDesk_14_TaskOutput model) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withModel(phase, model, Policies.of(user, groups)));
            return ResponseEntity.ok(pi.checkError().variables().toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @GetMapping(value = "/{id}/Questionnaire/{workItemId}", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDesk_14_TaskInput> getTask_Questionnaire_3(@PathVariable("id") String id, @PathVariable("workItemId") String workItemId, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups) {
        return process.instances().findById(id).map(pi -> ServiceDesk_14_TaskInput.from(pi.workItem(workItemId, Policies.of(user, groups)))).map(m -> ResponseEntity.ok(m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value = "Questionnaire/schema", produces = MediaType.APPLICATION_JSON_VALUE)
    public Map<String, Object> getSchema_Questionnaire_3() {
        return JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "Questionnaire");
    }

    @GetMapping(value = "/{id}/Questionnaire/{workItemId}/schema", produces = MediaType.APPLICATION_JSON_VALUE)
    public Map<String, Object> getSchemaAndPhases_Questionnaire_3(@PathVariable("id") final String id, @PathVariable("workItemId") final String workItemId, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups) {
        return JsonSchemaUtil.addPhases(process, application, id, workItemId, Policies.of(user, groups), JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "Questionnaire"));
    }

    @DeleteMapping(value = "/{id}/Questionnaire/{workItemId}", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDeskModelOutput> abortTask_Questionnaire_3(@PathVariable("id") final String id, @PathVariable("workItemId") final String workItemId, @RequestParam(value = "phase", required = false, defaultValue = "abort") final String phase, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withoutModel(phase, Policies.of(user, groups)));
            return ResponseEntity.ok(pi.checkError().variables().toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value = "/{id}/ReceiveCustomerComment", produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDeskModelOutput> signal_ReceiveCustomerComment_4(@PathVariable("id") final String id, final UriComponentsBuilder uriComponentsBuilder) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.send(Sig.of("Receive customer comment", java.util.Collections.emptyMap()));
            java.util.Optional<WorkItem> task = pi.workItems().stream().filter(wi -> wi.getName().equals("ReceiveCustomerComment")).findFirst();
            if (task.isPresent()) {
                UriComponents uriComponents = uriComponentsBuilder.path("/serviceDesk/{id}/ReceiveCustomerComment/{taskId}").buildAndExpand(id, task.get().getId());
                URI location = uriComponents.toUri();
                return ResponseEntity.created(location).body(pi.checkError().variables().toOutput());
            }
            return new ResponseEntity<ServiceDeskModelOutput>(HttpStatus.NOT_FOUND);
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value = "/{id}/ReceiveCustomerComment/{workItemId}", produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDeskModelOutput> completeTask_ReceiveCustomerComment_4(@PathVariable("id") final String id, @PathVariable("workItemId") final String workItemId, @RequestParam(value = "phase", required = false, defaultValue = "complete") final String phase, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups, @RequestBody(required = false) final ServiceDesk_16_TaskOutput model) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withModel(phase, model, Policies.of(user, groups)));
            return ResponseEntity.ok(pi.checkError().variables().toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @GetMapping(value = "/{id}/ReceiveCustomerComment/{workItemId}", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDesk_16_TaskInput> getTask_ReceiveCustomerComment_4(@PathVariable("id") String id, @PathVariable("workItemId") String workItemId, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups) {
        return process.instances().findById(id).map(pi -> ServiceDesk_16_TaskInput.from(pi.workItem(workItemId, Policies.of(user, groups)))).map(m -> ResponseEntity.ok(m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value = "ReceiveCustomerComment/schema", produces = MediaType.APPLICATION_JSON_VALUE)
    public Map<String, Object> getSchema_ReceiveCustomerComment_4() {
        return JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ReceiveCustomerComment");
    }

    @GetMapping(value = "/{id}/ReceiveCustomerComment/{workItemId}/schema", produces = MediaType.APPLICATION_JSON_VALUE)
    public Map<String, Object> getSchemaAndPhases_ReceiveCustomerComment_4(@PathVariable("id") final String id, @PathVariable("workItemId") final String workItemId, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups) {
        return JsonSchemaUtil.addPhases(process, application, id, workItemId, Policies.of(user, groups), JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ReceiveCustomerComment"));
    }

    @DeleteMapping(value = "/{id}/ReceiveCustomerComment/{workItemId}", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDeskModelOutput> abortTask_ReceiveCustomerComment_4(@PathVariable("id") final String id, @PathVariable("workItemId") final String workItemId, @RequestParam(value = "phase", required = false, defaultValue = "abort") final String phase, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withoutModel(phase, Policies.of(user, groups)));
            return ResponseEntity.ok(pi.checkError().variables().toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value = "/{id}/ReceiveSupportComment", produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDeskModelOutput> signal_ReceiveSupportComment_5(@PathVariable("id") final String id, final UriComponentsBuilder uriComponentsBuilder) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.send(Sig.of("Receive support comment", java.util.Collections.emptyMap()));
            java.util.Optional<WorkItem> task = pi.workItems().stream().filter(wi -> wi.getName().equals("ReceiveSupportComment")).findFirst();
            if (task.isPresent()) {
                UriComponents uriComponents = uriComponentsBuilder.path("/serviceDesk/{id}/ReceiveSupportComment/{taskId}").buildAndExpand(id, task.get().getId());
                URI location = uriComponents.toUri();
                return ResponseEntity.created(location).body(pi.checkError().variables().toOutput());
            }
            return new ResponseEntity<ServiceDeskModelOutput>(HttpStatus.NOT_FOUND);
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value = "/{id}/ReceiveSupportComment/{workItemId}", produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDeskModelOutput> completeTask_ReceiveSupportComment_5(@PathVariable("id") final String id, @PathVariable("workItemId") final String workItemId, @RequestParam(value = "phase", required = false, defaultValue = "complete") final String phase, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups, @RequestBody(required = false) final ServiceDesk_17_TaskOutput model) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withModel(phase, model, Policies.of(user, groups)));
            return ResponseEntity.ok(pi.checkError().variables().toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @GetMapping(value = "/{id}/ReceiveSupportComment/{workItemId}", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDesk_17_TaskInput> getTask_ReceiveSupportComment_5(@PathVariable("id") String id, @PathVariable("workItemId") String workItemId, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups) {
        return process.instances().findById(id).map(pi -> ServiceDesk_17_TaskInput.from(pi.workItem(workItemId, Policies.of(user, groups)))).map(m -> ResponseEntity.ok(m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value = "ReceiveSupportComment/schema", produces = MediaType.APPLICATION_JSON_VALUE)
    public Map<String, Object> getSchema_ReceiveSupportComment_5() {
        return JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ReceiveSupportComment");
    }

    @GetMapping(value = "/{id}/ReceiveSupportComment/{workItemId}/schema", produces = MediaType.APPLICATION_JSON_VALUE)
    public Map<String, Object> getSchemaAndPhases_ReceiveSupportComment_5(@PathVariable("id") final String id, @PathVariable("workItemId") final String workItemId, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups) {
        return JsonSchemaUtil.addPhases(process, application, id, workItemId, Policies.of(user, groups), JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "ReceiveSupportComment"));
    }

    @DeleteMapping(value = "/{id}/ReceiveSupportComment/{workItemId}", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ServiceDeskModelOutput> abortTask_ReceiveSupportComment_5(@PathVariable("id") final String id, @PathVariable("workItemId") final String workItemId, @RequestParam(value = "phase", required = false, defaultValue = "abort") final String phase, @RequestParam(value = "user", required = false) final String user, @RequestParam(value = "group", required = false, defaultValue = "") final List<String> groups) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withoutModel(phase, Policies.of(user, groups)));
            return ResponseEntity.ok(pi.checkError().variables().toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }
}
