/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.examples.sw.github.service;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.kogito.examples.sw.github.service.GitHubWrapperService;

@Path(value="/repo")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class GitHubResource {
    @Inject
    GitHubWrapperService gitHubService;

    @POST
    @Path(value="/{user}/{name}/pr/{number}/labels")
    public Response addLabels(@PathParam(value="user") String user, @PathParam(value="name") String repoName, @PathParam(value="number") Integer prNumber, List<String> labels) {
        try {
            this.gitHubService.addLabels(user, repoName, prNumber, labels);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="/{user}/{name}/pr/{number}/reviewers")
    public Response addReviewers(@PathParam(value="user") String user, @PathParam(value="name") String repoName, @PathParam(value="number") Integer prNumber, List<String> reviewers) {
        try {
            this.gitHubService.addReviewers(user, repoName, prNumber, reviewers);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/{user}/{name}/pr/{number}/files")
    public Response fetchFiles(@PathParam(value="user") String user, @PathParam(value="name") String repoName, @PathParam(value="number") Integer prNumber) {
        try {
            return Response.ok().entity(this.gitHubService.fetchChangedFilesPath(user, repoName, prNumber)).build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

