/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.examples.sw.github.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kogito.examples.sw.github.service.GitHubWrapperService;
import org.kogito.examples.sw.github.service.TokenProvider;
import org.kohsuke.github.GHPullRequestFileDetail;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class GitHubWrapperServiceImpl
implements GitHubWrapperService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubWrapperServiceImpl.class);
    @Inject
    TokenProvider tokenProvider;

    @Override
    public void addLabels(String user, String repository, int issueId, List<String> labels) throws Exception {
        LOGGER.info("Adding labels for the repo {}/{} issue {} labels {}", new Object[]{user, repository, issueId, labels});
        GitHub gitHub = new GitHubBuilder().withAppInstallationToken(this.tokenProvider.getToken()).build();
        gitHub.getRepository(this.toRepositoryName(user, repository)).getIssue(issueId).addLabels(labels.toArray(new String[0]));
        LOGGER.info("Labels {} added to the Issue/PR {}", labels, (Object)issueId);
    }

    @Override
    public void addReviewers(String user, String repository, int prId, List<String> reviewers) throws Exception {
        LOGGER.info("Adding reviewers for the repo {}/{} PR {} labels {}", new Object[]{user, repository, prId, reviewers});
        GitHub gitHub = new GitHubBuilder().withAppInstallationToken(this.tokenProvider.getToken()).build();
        gitHub.getRepository(this.toRepositoryName(user, repository)).getPullRequest(prId).requestReviewers(this.toUsers(gitHub, reviewers));
        LOGGER.info("Reviewers {} added to the PR {}", reviewers, (Object)prId);
    }

    @Override
    public List<String> fetchChangedFilesPath(String user, String repository, int prId) throws Exception {
        LOGGER.info("Fetching files for the repo {}/{} PR {}", new Object[]{user, repository, prId});
        ArrayList<String> filesPath = new ArrayList<String>();
        GitHub gitHub = new GitHubBuilder().withAppInstallationToken(this.tokenProvider.getToken()).build();
        for (GHPullRequestFileDetail ghPullRequestFileDetail : gitHub.getRepository(this.toRepositoryName(user, repository)).getPullRequest(prId).listFiles()) {
            filesPath.add(ghPullRequestFileDetail.getFilename());
        }
        LOGGER.info("Fetched files {} for PR {}", filesPath, (Object)prId);
        return filesPath;
    }

    private String toRepositoryName(String user, String repository) {
        return user.concat("/").concat(repository);
    }

    private List<GHUser> toUsers(GitHub gitHub, List<String> userIds) throws IOException {
        ArrayList<GHUser> users = new ArrayList<GHUser>();
        if (userIds != null) {
            for (String u : userIds) {
                users.add(gitHub.getUser(u));
            }
        }
        return users;
    }
}

