/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.infinispan;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.io.impl.ClassPathResource;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.node.ActionNode;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Node;
import org.kie.api.io.Resource;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.persistence.KogitoProcessInstancesFactory;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceNotFoundException;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class MockCacheProcessInstancesTest {
    private final ConcurrentHashMap<Object, Object> mockCache = new ConcurrentHashMap();
    private RemoteCacheManager cacheManager;

    @BeforeEach
    public void setup() {
        this.mockCache.clear();
        this.cacheManager = (RemoteCacheManager)Mockito.mock(RemoteCacheManager.class);
        RemoteCacheManagerAdmin admin = (RemoteCacheManagerAdmin)Mockito.mock(RemoteCacheManagerAdmin.class);
        RemoteCache cache = (RemoteCache)Mockito.mock(RemoteCache.class);
        Mockito.when((Object)this.cacheManager.administration()).thenReturn((Object)admin);
        Mockito.when((Object)admin.getOrCreateCache((String)Mockito.any(), (String)Mockito.any())).thenReturn((Object)cache);
        Mockito.when((Object)cache.put(Mockito.any(), Mockito.any())).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object key = invocation.getArgument(0, Object.class);
                Object value = invocation.getArgument(1, Object.class);
                return MockCacheProcessInstancesTest.this.mockCache.put(key, value);
            }
        });
        Mockito.when((Object)cache.putIfAbsent(Mockito.any(), Mockito.any())).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object key = invocation.getArgument(0, Object.class);
                Object value = invocation.getArgument(1, Object.class);
                return MockCacheProcessInstancesTest.this.mockCache.put(key, value);
            }
        });
        Mockito.when((Object)cache.get(Mockito.any())).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object key = invocation.getArgument(0, Object.class);
                return MockCacheProcessInstancesTest.this.mockCache.get(key);
            }
        });
    }

    @Test
    public void testBasicFlow() {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-UserTask.bpmn2")).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new CacheProcessInstancesFactory(this.cacheManager));
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        WorkItem workItem = (WorkItem)processInstance.workItems(new Policy[]{SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"))}).get(0);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat(workItem.getParameters().get("ActorId")).isEqualTo((Object)"john");
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"))});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testBasicFlowNoActors() {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-UserTask-NoActors.bpmn2")).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new CacheProcessInstancesFactory(this.cacheManager));
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        WorkItem workItem = (WorkItem)processInstance.workItems(new Policy[0]).get(0);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat(workItem.getParameters().get("ActorId")).isNull();
        List workItems = processInstance.workItems(new Policy[]{SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"))});
        Assertions.assertThat((List)workItems).hasSize(1);
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[0]);
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testProcessInstanceNotFound() {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-UserTask.bpmn2")).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new CacheProcessInstancesFactory(this.cacheManager));
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        this.mockCache.clear();
        Assertions.assertThatThrownBy(() -> {
            WorkItem cfr_ignored_0 = (WorkItem)processInstance.workItems(new Policy[0]).get(0);
        }).isInstanceOf(ProcessInstanceNotFoundException.class);
        Optional loaded = process.instances().findById(processInstance.id());
        Assertions.assertThat((Optional)loaded).isNotPresent();
    }

    @Test
    public void testBasicFlowWithErrorAndRetry() {
        this.testBasicFlowWithError(processInstance -> {
            processInstance.updateVariables((Object)BpmnVariables.create(Collections.singletonMap("s", "test")));
            ((ProcessError)processInstance.error().orElseThrow(() -> new IllegalStateException("Process instance not in error"))).retrigger();
        });
    }

    @Test
    public void testBasicFlowWithErrorAndSkip() {
        this.testBasicFlowWithError(processInstance -> {
            processInstance.updateVariables((Object)BpmnVariables.create(Collections.singletonMap("s", "test")));
            ((ProcessError)processInstance.error().orElseThrow(() -> new IllegalStateException("Process instance not in error"))).skip();
        });
    }

    private void testBasicFlowWithError(Consumer<ProcessInstance<BpmnVariables>> op) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-UserTask-Script.bpmn2")).get(0);
        for (Node node : ((WorkflowProcess)process.legacyProcess()).getNodes()) {
            if (!(node instanceof ActionNode)) continue;
            DroolsAction a = ((ActionNode)node).getAction();
            a.setMetaData("Action", (Object)new Action(){

                public void execute(ProcessContext kcontext) throws Exception {
                    System.out.println("The variable value is " + kcontext.getVariable("s") + " about to call toString on it");
                    kcontext.getVariable("s").toString();
                }
            });
        }
        process.setProcessInstancesFactory((ProcessInstancesFactory)new CacheProcessInstancesFactory(this.cacheManager));
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create());
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(5);
        Optional errorOp = processInstance.error();
        Assertions.assertThat((Optional)errorOp).isPresent();
        Assertions.assertThat((String)((ProcessError)errorOp.get()).failedNodeId()).isEqualTo("ScriptTask_1");
        ((AbstractStringAssert)Assertions.assertThat((String)((ProcessError)errorOp.get()).errorMessage()).isNotNull()).contains(new CharSequence[]{"java.lang.NullPointerException - null"});
        op.accept((ProcessInstance<BpmnVariables>)processInstance);
        WorkItem workItem = (WorkItem)processInstance.workItems(new Policy[]{SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"))}).get(0);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat(workItem.getParameters().get("ActorId")).isEqualTo((Object)"john");
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"))});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    private class CacheProcessInstancesFactory
    extends KogitoProcessInstancesFactory {
        CacheProcessInstancesFactory(RemoteCacheManager cacheManager) {
            super(cacheManager);
        }

        public String proto() {
            return null;
        }

        public List<?> marshallers() {
            return Collections.emptyList();
        }
    }
}

