/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.infinispan.health;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.inject.Provider;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;

public class InfinispanHealthCheck
implements HealthCheck {
    private Optional<RemoteCacheManager> cacheManagerOptional;

    public InfinispanHealthCheck(Instance<RemoteCacheManager> cacheManagerInstance) {
        this.cacheManagerOptional = Optional.of(cacheManagerInstance).filter(Instance::isResolvable).map(Provider::get);
    }

    public HealthCheckResponse call() {
        return this.cacheManagerOptional.map(cacheManager -> {
            ChannelFactory channelFactory = cacheManager.getChannelFactory();
            Codec codec = cacheManager.getCodec();
            Configuration configuration = cacheManager.getConfiguration();
            ClientListenerNotifier listenerNotifier = new ClientListenerNotifier(codec, cacheManager.getMarshaller(), channelFactory, configuration);
            OperationsFactory operationsFactory = new OperationsFactory(channelFactory, codec, listenerNotifier, configuration);
            return Optional.of(channelFactory.getServers().stream().map(server -> this.invokePingOperation(channelFactory, operationsFactory, (SocketAddress)server).thenApply(PingResponse::isSuccess).exceptionally(ex -> false)).map(op -> {
                try {
                    return (Boolean)op.get(500L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    return false;
                }
            }).allMatch(Boolean.FALSE::equals)).map(allDown -> this.buildResponse(channelFactory, allDown == false)).orElse(this.buildResponse(channelFactory, false));
        }).orElse(null);
    }

    private HealthCheckResponse buildResponse(ChannelFactory channelFactory, boolean state) {
        return HealthCheckResponse.builder().withData("nodes", ((Collection)Optional.ofNullable(channelFactory.getServers()).orElse(Collections.emptyList())).stream().map(String::valueOf).collect(Collectors.joining(","))).name(state ? "Infinispan is Up" : "Infinispan is Down").state(state).build();
    }

    private PingOperation invokePingOperation(ChannelFactory channelFactory, OperationsFactory operationsFactory, SocketAddress server) {
        return (PingOperation)channelFactory.fetchChannelAndInvoke(server, (ChannelOperation)operationsFactory.newPingOperation(true));
    }
}

