/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.it.jobs;

import io.restassured.path.json.JsonPath;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.config.ConfigProvider;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.test.TestUtils;
import org.kie.kogito.test.quarkus.kafka.KafkaTestClient;

public abstract class BaseSwitchStateTimeoutsIT {
    protected static final String SWITCH_STATE_TIMEOUTS_URL = "/switch_state_timeouts";
    private static final String SWITCH_STATE_TIMEOUTS_GET_BY_ID_URL = "/switch_state_timeouts/{id}";
    private static final String EVENT_DECISION_PATH = "data.decision";
    private static final String EVENT_PROCESS_INSTANCE_ID_PATH = "kogitoprocinstanceid";
    private static final String EVENT_TYPE_PATH = "type";
    private static final String DECISION_NO_DECISION = "NoDecision";
    private static final String KOGITO_OUTGOING_STREAM_TOPIC = "kogito-sw-out-events";
    private static final String PROCESS_RESULT_EVENT_TYPE = "process_result_event";
    private static final String EMPTY_WORKFLOW_DATA = "{\"workflowdata\" : \"\"}";
    private KafkaTestClient kafkaClient;

    @BeforeEach
    void setup() {
        String kafkaBootstrapServers = (String)ConfigProvider.getConfig().getValue("kafka.bootstrap.servers", String.class);
        this.kafkaClient = new KafkaTestClient(kafkaBootstrapServers);
    }

    @AfterEach
    void cleanUp() {
        this.kafkaClient.shutdown();
    }

    @Test
    void switchStateEventConditionTimeoutsTransitionTimeoutsExceeded() throws Exception {
        String processInstanceId = TestUtils.newProcessInstanceAndGetId((String)SWITCH_STATE_TIMEOUTS_URL, (String)EMPTY_WORKFLOW_DATA);
        TestUtils.assertProcessInstanceHasFinished((String)SWITCH_STATE_TIMEOUTS_GET_BY_ID_URL, (String)processInstanceId, (long)1L, (long)180L);
        JsonPath result = TestUtils.waitForEvent((KafkaTestClient)this.kafkaClient, (String)KOGITO_OUTGOING_STREAM_TOPIC, (long)50L);
        BaseSwitchStateTimeoutsIT.assertDecisionEvent(result, processInstanceId, PROCESS_RESULT_EVENT_TYPE, DECISION_NO_DECISION);
    }

    protected static void assertDecisionEvent(JsonPath cloudEventJsonPath, String expectedProcessInstanceId, String expectedEventType, String expectedDecision) {
        Assertions.assertThat((String)cloudEventJsonPath.getString(EVENT_PROCESS_INSTANCE_ID_PATH)).isEqualTo(expectedProcessInstanceId);
        Assertions.assertThat((String)cloudEventJsonPath.getString(EVENT_TYPE_PATH)).isEqualTo(expectedEventType);
        Assertions.assertThat((String)cloudEventJsonPath.getString(EVENT_DECISION_PATH)).isEqualTo(expectedDecision);
    }
}

