/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.it.jobs;

import io.restassured.path.json.JsonPath;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.test.TestUtils;

public abstract class BaseSwitchStateTimeoutsIT {
    protected static final String SWITCH_STATE_TIMEOUTS_URL = "/switch_state_timeouts";
    private static final String SWITCH_STATE_TIMEOUTS_GET_BY_ID_URL = "/switch_state_timeouts/{id}";
    private static final String EVENT_DECISION_PATH = "data.decision";
    private static final String EVENT_PROCESS_INSTANCE_ID_PATH = "kogitoprocinstanceid";
    private static final String EVENT_TYPE_PATH = "type";
    protected static final String DECISION_NO_DECISION = "NoDecision";
    protected static final String PROCESS_RESULT_EVENT_TYPE = "process_result_event";
    private static final String EMPTY_WORKFLOW_DATA = "{\"workflowdata\" : \"\"}";

    @Test
    void switchStateEventConditionTimeoutsTransitionTimeoutsExceeded() throws Exception {
        String processInstanceId = TestUtils.newProcessInstanceAndGetId((String)SWITCH_STATE_TIMEOUTS_URL, (String)EMPTY_WORKFLOW_DATA);
        TestUtils.assertProcessInstanceHasFinished((String)SWITCH_STATE_TIMEOUTS_GET_BY_ID_URL, (String)processInstanceId, (long)1L, (long)180L);
        this.verifyNoDecisionEventWasProduced(processInstanceId);
    }

    protected abstract void verifyNoDecisionEventWasProduced(String var1) throws Exception;

    protected static void assertDecisionEvent(JsonPath cloudEventJsonPath, String expectedProcessInstanceId, String expectedEventType, String expectedDecision) {
        Assertions.assertThat((String)cloudEventJsonPath.getString(EVENT_PROCESS_INSTANCE_ID_PATH)).isEqualTo(expectedProcessInstanceId);
        Assertions.assertThat((String)cloudEventJsonPath.getString(EVENT_TYPE_PATH)).isEqualTo(expectedEventType);
        Assertions.assertThat((String)cloudEventJsonPath.getString(EVENT_DECISION_PATH)).isEqualTo(expectedDecision);
    }
}

