/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test.resources;

import io.quarkus.test.common.QuarkusTestResourceConfigurableLifecycleManager;
import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.index.testcontainers.DataIndexPostgreSqlContainer;
import org.kie.kogito.test.resources.CompositeTestResource;
import org.kie.kogito.test.resources.JobServiceTestResource;
import org.kie.kogito.testcontainers.JobServiceContainer;
import org.kie.kogito.testcontainers.KogitoGenericContainer;
import org.kie.kogito.testcontainers.KogitoKafkaContainer;
import org.kie.kogito.testcontainers.KogitoPostgreSqlContainer;
import org.testcontainers.containers.GenericContainer;

public class JobServiceCompositeQuarkusTestResource
implements QuarkusTestResourceConfigurableLifecycleManager<JobServiceTestResource> {
    public static final String JOBS_SERVICE_URL = "kogito.jobs-service.url";
    public static final String DATA_INDEX_SERVICE_URL = "kogito.data-index.url";
    private JobServiceTestResource annotation;
    private CompositeTestResource resource = new CompositeTestResource((KogitoGenericContainer)new JobServiceContainer());

    public void init(JobServiceTestResource annotation) {
        this.annotation = annotation;
        switch (annotation.persistence()) {
            case POSTGRESQL: {
                this.resource.withDependencyToService("main-service", new GenericContainer[]{new KogitoPostgreSqlContainer()});
                break;
            }
        }
        if (annotation.kafkaEnabled()) {
            this.resource.withSharedDependencyContainer("kafka", (GenericContainer)new KogitoKafkaContainer());
            this.resource.getServiceContainers(JobServiceContainer.class).forEach(c -> c.addEnv("QUARKUS_PROFILE", "kafka-events-support"));
        }
        if (annotation.knativeEventingEnabled()) {
            this.resource.getServiceContainers(JobServiceContainer.class).forEach(c -> {
                c.addEnv("QUARKUS_PROFILE", "http-events-support");
                c.addEnv("KOGITO_JOBS_SERVICE_HTTP_JOB_STATUS_CHANGE_EVENTS", "false");
            });
        }
        if (annotation.dataIndexEnabled()) {
            DataIndexPostgreSqlContainer container = new DataIndexPostgreSqlContainer();
            container.addProtoFileFolder();
            container.addEnv("QUARKUS_PROFILE", "kafka-events-support");
            KogitoPostgreSqlContainer postgresql = new KogitoPostgreSqlContainer();
            this.resource.withServiceContainer("data-index", (KogitoGenericContainer)container, new GenericContainer[]{postgresql});
        }
    }

    public void stop() {
        this.resource.stop();
    }

    public Map<String, String> start() {
        this.resource.start();
        HashMap<String, String> properties = new HashMap<String, String>(this.resource.getProperties());
        if (this.annotation.dataIndexEnabled()) {
            DataIndexPostgreSqlContainer dataIndexContainer = (DataIndexPostgreSqlContainer)this.resource.getServiceContainer("data-index");
            System.setProperty(DATA_INDEX_SERVICE_URL, "http://" + dataIndexContainer.getHost() + ":" + dataIndexContainer.getMappedPort());
            properties.put(DATA_INDEX_SERVICE_URL, "http://" + dataIndexContainer.getHost() + ":" + dataIndexContainer.getMappedPort());
        }
        System.setProperty(JOBS_SERVICE_URL, "http://localhost:" + this.resource.getMappedPort());
        properties.put(JOBS_SERVICE_URL, "http://localhost:" + this.resource.getMappedPort());
        return properties;
    }
}

