/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.kie.kogito.test.quarkus.kafka.KafkaTestClient;
import org.testcontainers.shaded.org.awaitility.Awaitility;

public class TestUtils {
    private TestUtils() {
    }

    public static void assertProcessInstanceExists(String getProcessByIdQuery, String processInstanceId) {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).when().get(getProcessByIdQuery, new Object[]{processInstanceId})).then()).statusCode(200);
    }

    public static void assertProcessInstanceHasFinished(String getProcessByIdQuery, String processInstanceId, long atLeastTimeoutInSeconds, long atMostTimeoutInSeconds) {
        Awaitility.await().atLeast(atLeastTimeoutInSeconds, TimeUnit.SECONDS).atMost(atMostTimeoutInSeconds, TimeUnit.SECONDS).with().pollInterval(1L, TimeUnit.SECONDS).untilAsserted(() -> ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).get(getProcessByIdQuery, new Object[]{processInstanceId})).then()).statusCode(404));
    }

    public static String newProcessInstanceAndGetId(String processUrl, String processInput) {
        return (String)TestUtils.newProcessInstance(processUrl, processInput).get("id");
    }

    public static JsonPath newProcessInstance(String processUrl, String processInput) {
        JsonPath result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(processInput).post(processUrl, new Object[0])).then()).statusCode(201)).extract().jsonPath();
        String processInstanceId = (String)result.get("id");
        Assertions.assertThat((String)processInstanceId).isNotBlank();
        return result;
    }

    public static JsonPath waitForEvent(KafkaTestClient kafkaClient, String topic, long seconds) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference cloudEvent = new AtomicReference();
        kafkaClient.consume(topic, rawCloudEvent -> {
            cloudEvent.set(rawCloudEvent);
            countDownLatch.countDown();
        });
        Assertions.assertThat((boolean)countDownLatch.await(seconds, TimeUnit.SECONDS)).isTrue();
        return new JsonPath((String)cloudEvent.get());
    }
}

