/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.it.jobs;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.Duration;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseProcessAsyncIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseProcessAsyncIT.class);
    public static final String ASYNC = "async";
    public static final Duration TIMEOUT = Duration.ofMinutes(5L);

    @Test
    public void testAsync() {
        ValidatableResponse created = this.create(new RequestPayload("Tiago"), ASYNC);
        String id = (String)created.extract().path("id", new String[0]);
        created.body("hello", CoreMatchers.nullValue(), new Object[0]);
        created.body("bye", CoreMatchers.nullValue(), new Object[0]);
        Awaitility.await().atMost(TIMEOUT).untilAsserted(() -> {
            ValidatableResponse response = this.getById(ASYNC, id);
            response.body("hello", CoreMatchers.equalTo((Object)"Hello Tiago"), new Object[0]);
            response.body("bye", CoreMatchers.nullValue(), new Object[0]);
        });
        ValidatableResponse complete = this.signal(ASYNC, id, "bye");
        complete.body("bye", CoreMatchers.nullValue(), new Object[0]);
        Awaitility.await().atMost(TIMEOUT).untilAsserted(() -> {
            LOGGER.info("Checking bye equalTo(\"Bye Tiago\") assertion");
            this.getById(ASYNC, id).body("bye", CoreMatchers.equalTo((Object)"Bye Tiago"), new Object[0]);
        });
        this.signal(ASYNC, id, "complete");
        Awaitility.await().atMost(TIMEOUT).untilAsserted(() -> this.getWithStatusCode(ASYNC, id, 404));
    }

    private ValidatableResponse getWithStatusCode(String path, String id, int code) {
        return (ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/" + path + "/{id}", new Object[]{id})).then()).statusCode(code);
    }

    private ValidatableResponse create(RequestPayload request, String path) {
        return (ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body((Object)request).when().post("/" + path, new Object[0])).then()).statusCode(201);
    }

    private ValidatableResponse getById(String path, String id) {
        return this.getWithStatusCode(path, id, 200);
    }

    private ValidatableResponse signal(String path, String id, String signal) {
        return (ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).when().post("/" + path + "/" + id + "/" + signal, new Object[0])).then()).statusCode(200);
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    private class RequestPayload {
        private String name;

        public RequestPayload(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

