/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test.resources;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.kogito.test.resources.TestResource;
import org.kie.kogito.testcontainers.KogitoGenericContainer;
import org.kie.kogito.testcontainers.KogitoKafkaContainer;
import org.kie.kogito.testcontainers.KogitoPostgreSqlContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class CompositeTestResource
implements TestResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeTestResource.class);
    public static final String MAIN_SERVICE_ID = "main-service";
    private final Map<String, GenericContainer<?>> sharedDependencyContainers = new HashMap();
    private final Map<String, KogitoGenericContainer<?>> serviceContainers;
    private final Map<String, List<GenericContainer<?>>> dependencyContainers = new HashMap();
    private final KogitoGenericContainer<?> mainContainer;
    private final Map<String, String> properties;

    public CompositeTestResource(KogitoGenericContainer<?> mainContainer) {
        this.serviceContainers = new HashMap();
        this.properties = new HashMap<String, String>();
        this.mainContainer = mainContainer;
        this.withServiceContainer(MAIN_SERVICE_ID, mainContainer, new GenericContainer[0]);
    }

    public CompositeTestResource withServiceContainer(String id, KogitoGenericContainer<?> container, GenericContainer<?> ... dependency) {
        this.serviceContainers.put(id, container);
        return this.withDependencyToService(id, dependency);
    }

    public CompositeTestResource withDependencyToService(String serviceId, GenericContainer<?> ... dependency) {
        List containers = this.dependencyContainers.getOrDefault(serviceId, new ArrayList());
        containers.addAll(Arrays.asList(dependency));
        this.dependencyContainers.put(serviceId, containers);
        return this;
    }

    public CompositeTestResource withSharedDependencyContainer(String prefix, GenericContainer<?> container) {
        this.sharedDependencyContainers.put(prefix, container);
        return this;
    }

    public <T> List<T> getServiceContainers(Class<T> type) {
        return this.serviceContainers.values().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }

    public <T extends KogitoGenericContainer<?>> T getServiceContainer(String id) {
        return (T)this.serviceContainers.get(id);
    }

    private String hostName(GenericContainer<?> container) {
        return container.getContainerInfo().getConfig().getHostName();
    }

    public void start() {
        LOGGER.info("Starting {} Test Resource", this.mainContainer);
        Network network = Network.newNetwork();
        this.sharedDependencyContainers.values().stream().map(c -> c.withNetwork(network)).map(c -> c.waitingFor((WaitStrategy)Wait.forListeningPort())).forEach(GenericContainer::start);
        this.configureKafkaToService(this.sharedDependencyContainers.values(), (GenericContainer[])this.serviceContainers.values().toArray(GenericContainer[]::new));
        this.startServices(network);
    }

    protected void startServices(Network network) {
        this.serviceContainers.entrySet().stream().map(entry -> {
            List<GenericContainer<?>> dependencies = this.dependencyContainers.getOrDefault(entry.getKey(), Collections.emptyList()).stream().map(container -> container.withNetwork(network)).map(container -> {
                if (!container.isRunning()) {
                    container.start();
                }
                return container;
            }).collect(Collectors.toList());
            this.configurePostgreSQLToService(dependencies, (GenericContainer)this.serviceContainers.get(entry.getKey()));
            this.configureKafkaToService(dependencies, (GenericContainer)this.serviceContainers.get(entry.getKey()));
            return entry;
        }).map(Map.Entry::getValue).forEach(service -> {
            service.withNetwork(network);
            service.start();
            LOGGER.info("Test resource started");
        });
    }

    protected void configureKafkaToService(Collection<GenericContainer<?>> containers, GenericContainer<?> ... services) {
        containers.stream().filter(KogitoKafkaContainer.class::isInstance).map(KogitoKafkaContainer.class::cast).findFirst().ifPresent(kafka -> {
            String kafkaURL = kafka.getBootstrapServers();
            this.properties.put("kafka.bootstrap.servers", kafkaURL);
            this.properties.put("spring.kafka.bootstrap-servers", kafkaURL);
            String kafkaInternalUrl = this.hostName((GenericContainer<?>)kafka) + ":29092";
            Stream.of(services).forEach(service -> service.addEnv("KAFKA_BOOTSTRAP_SERVERS", kafkaInternalUrl));
        });
    }

    protected void configurePostgreSQLToService(Collection<GenericContainer<?>> containers, GenericContainer<?> ... services) {
        containers.stream().filter(KogitoPostgreSqlContainer.class::isInstance).map(KogitoPostgreSqlContainer.class::cast).findFirst().ifPresent(postgreSql -> {
            String connectionTemplate = "postgresql://{0}:{1}/{2}";
            String jdbcConnectionTemplate = "jdbc:postgresql://{0}:{1}/{2}";
            String server = this.hostName((GenericContainer<?>)postgreSql);
            String port = "5432";
            String username = postgreSql.getUsername();
            String password = postgreSql.getPassword();
            String database = postgreSql.getDatabaseName();
            String reactiveUrl = MessageFormat.format("postgresql://{0}:{1}/{2}", server, "5432", database);
            String jdbcUrl = MessageFormat.format("jdbc:postgresql://{0}:{1}/{2}", server, "5432", database);
            Stream.of(services).forEach(service -> {
                service.addEnv("QUARKUS_DATASOURCE_JDBC_URL", jdbcUrl);
                service.addEnv("QUARKUS_DATASOURCE_REACTIVE_URL", reactiveUrl);
                service.addEnv("QUARKUS_DATASOURCE_USERNAME", username);
                service.addEnv("QUARKUS_DATASOURCE_PASSWORD", password);
                service.addEnv("QUARKUS_DATASOURCE_DB-KIND", "postgresql");
                service.addEnv("QUARKUS_FLYWAY_MIGRATE_AT_START", "true");
                service.addEnv("QUARKUS_FLYWAY_BASELINE_ON_MIGRATE", "true");
                service.addEnv("QUARKUS_FLYWAY_CLEAN_AT_START", "false");
            });
        });
    }

    public void stop() {
        LOGGER.info("Stopping test resource");
        this.serviceContainers.values().forEach(GenericContainer::stop);
        this.sharedDependencyContainers.values().forEach(GenericContainer::stop);
        this.dependencyContainers.values().stream().flatMap(Collection::stream).forEach(GenericContainer::stop);
    }

    public String getResourceName() {
        return this.mainContainer.getContainerName();
    }

    public int getMappedPort() {
        return this.mainContainer.getMappedPort(8080);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

