/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.kie.kogito.test.quarkus.kafka.KafkaTestClient;

public class TestUtils {
    private TestUtils() {
    }

    public static JsonPath waitForEvent(KafkaTestClient kafkaClient, String topic, long seconds) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference cloudEvent = new AtomicReference();
        kafkaClient.consume(topic, rawCloudEvent -> {
            cloudEvent.set(rawCloudEvent);
            countDownLatch.countDown();
        });
        Assertions.assertThat((boolean)countDownLatch.await(seconds, TimeUnit.SECONDS)).isTrue();
        return new JsonPath((String)cloudEvent.get());
    }

    public static void assertJobsAndProcessOnDataIndex(String dataIndexURL, String processId, String processInstanceId, String processStatus, String jobStatus, Duration timeout) {
        if (dataIndexURL != null) {
            String query = "{  \"query\" : \"{ProcessInstances (where : {    id: {equal : \\\"" + processInstanceId + "\\\" }  }) {    id,processId,state  }}\"}";
            Awaitility.await().atMost(timeout).untilAsserted(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri(dataIndexURL).contentType(ContentType.JSON).body(query).when().post("/graphql", new Object[0])).then()).statusCode(200)).body("data.ProcessInstances.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.ProcessInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.ProcessInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.ProcessInstances[0].state", CoreMatchers.is((Object)processStatus), new Object[0]));
            String queryJobs = "{  \"query\" : \"{Jobs (where : {    processInstanceId: {equal : \\\"" + processInstanceId + "\\\" }  }) {    status  }}\"}";
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri(dataIndexURL).contentType(ContentType.JSON).body(queryJobs).when().post("/graphql", new Object[0])).then()).statusCode(200)).body("data.Jobs.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Jobs[0].status", CoreMatchers.is((Object)jobStatus), new Object[0]);
        }
    }
}

