/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.integrationtests.quarkus;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.math.BigDecimal;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.kie.kogito.integrationtests.quarkus.FaceMaskTestData;
import org.kie.kogito.integrationtests.quarkus.Human;

@QuarkusTest
public class FaceMaskIT {
    @Test
    public void testYoungBabyWithoutNeedForAMask() {
        FaceMaskTestData data = new FaceMaskTestData();
        data.setHuman(new Human(){
            {
                this.setAge(BigDecimal.ONE);
            }
        });
        data.setLocation("Building");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body((Object)data).contentType(ContentType.JSON).when().post("/FaceMask", new Object[0])).then()).statusCode(200)).body("'Face Mask Needed'", Matchers.equalTo((Object)"No"), new Object[0]);
    }

    @Test
    public void testSomeoneWithBreathingIssuesButInBuilding() {
        FaceMaskTestData data = new FaceMaskTestData();
        data.setHuman(new Human(){
            {
                this.setName("Jane Morison");
                this.setAge(BigDecimal.valueOf(38L));
            }
        });
        data.setLocation("Building");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body((Object)data).contentType(ContentType.JSON).when().post("/FaceMask", new Object[0])).then()).statusCode(200)).body("'Face Mask Needed'", Matchers.equalTo((Object)"Textile Mask"), new Object[0]);
    }

    @Test
    public void testSomeoneWithBreathingIssues() {
        FaceMaskTestData data = new FaceMaskTestData();
        data.setHuman(new Human(){
            {
                this.setName("Jane Morison");
                this.setAge(BigDecimal.valueOf(38L));
            }
        });
        data.setLocation("Nature");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body((Object)data).contentType(ContentType.JSON).when().post("/FaceMask", new Object[0])).then()).statusCode(200)).body("'Face Mask Needed'", Matchers.equalTo((Object)"No"), new Object[0]);
    }

    @Test
    public void testRespiratorNeededInABuilding() {
        FaceMaskTestData data = new FaceMaskTestData();
        data.setHuman(new Human(){
            {
                this.setName("George");
                this.setAge(BigDecimal.valueOf(38L));
            }
        });
        data.setLocation("Building");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body((Object)data).contentType(ContentType.JSON).when().post("/FaceMask", new Object[0])).then()).statusCode(200)).body("'Face Mask Needed'", Matchers.equalTo((Object)"Respirator"), new Object[0]);
    }

    @Test
    public void testSurgicalMaskNeededInCity() {
        FaceMaskTestData data = new FaceMaskTestData();
        data.setHuman(new Human(){
            {
                this.setName("George");
                this.setAge(BigDecimal.valueOf(38L));
            }
        });
        data.setLocation("City");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body((Object)data).contentType(ContentType.JSON).when().post("/FaceMask", new Object[0])).then()).statusCode(200)).body("'Face Mask Needed'", Matchers.equalTo((Object)"Surgical Mask"), new Object[0]);
    }
}

