/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.integrationtests.quarkus;

import io.quarkus.test.common.http.TestHTTPResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.net.URL;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
class OASIT {
    @TestHTTPResource(value="/")
    URL rootUrl;

    OASIT() {
    }

    @Test
    public void testOASisValid() {
        String url = this.rootUrl.toString() + "/q/openapi";
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setResolve(true);
        SwaggerParseResult result = new OpenAPIV3Parser().readLocation(url, null, parseOptions);
        Assertions.assertThat((List)result.getMessages()).isEmpty();
        OpenAPI openAPI = result.getOpenAPI();
        PathItem p1 = (PathItem)openAPI.getPaths().get((Object)"/basicAdd");
        Assertions.assertThat((Object)p1).isNotNull();
        Assertions.assertThat((Object)p1.getGet()).isNotNull();
        Assertions.assertThat((Object)p1.getPost()).isNotNull();
        PathItem p2 = (PathItem)openAPI.getPaths().get((Object)"/basicAdd/dmnresult");
        Assertions.assertThat((Object)p2).isNotNull();
        Assertions.assertThat((Object)p2.getPost()).isNotNull();
    }

    @Test
    public void testOASdmnDefinitions() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/dmnDefinitions.json", new Object[0])).then()).statusCode(200)).body("definitions", Matchers.aMapWithSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))), new Object[0]);
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }
}

