/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.dmn;

import io.quarkus.test.junit.QuarkusTest;
import java.util.HashMap;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNResult;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.decision.DecisionModels;

@QuarkusTest
public class TrafficViolationTest {
    @Inject
    DecisionModels decisionModels;

    @Test
    public void testEvaluateTrafficViolation() {
        DecisionModel trafficViolation = this.decisionModels.getDecisionModel("https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation");
        HashMap<String, Integer> driver = new HashMap<String, Integer>();
        driver.put("Points", 2);
        HashMap<String, Object> violation = new HashMap<String, Object>();
        violation.put("Type", "speed");
        violation.put("Actual Speed", 120);
        violation.put("Speed Limit", 100);
        HashMap<String, HashMap<String, Object>> context = new HashMap<String, HashMap<String, Object>>();
        context.put("Driver", driver);
        context.put("Violation", violation);
        DMNResult dmnResult = trafficViolation.evaluateAll(trafficViolation.newContext(context));
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("Should the driver be suspended?").getResult()).isEqualTo((Object)"No");
    }
}

