/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.pmml;

import io.quarkus.test.junit.QuarkusTest;
import java.util.HashMap;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.kie.api.pmml.PMML4Result;
import org.kie.kogito.prediction.PredictionModel;
import org.kie.kogito.prediction.PredictionModels;

@QuarkusTest
class PMMLRegressionTest {
    @Inject
    PredictionModels predictionModels;

    PMMLRegressionTest() {
    }

    @Test
    void testEvaluateLinRegResult() {
        PredictionModel linReg = this.predictionModels.getPredictionModel("PMMLRegression.pmml", "LinReg");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("fld1", 3.0);
        context.put("fld2", 2.0);
        context.put("fld3", "y");
        PMML4Result pmml4Result = linReg.evaluateAll(linReg.newContext(context));
        double fld4 = (Double)pmml4Result.getResultVariables().get("fld4");
        Assertions.assertThat((double)fld4).isEqualTo(52.5, Offset.offset((Number)0.1));
    }
}

