/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.canonical;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerFactory;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.core.event.DebugProcessEventListener;
import org.drools.core.io.impl.ClassPathResource;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.compiler.canonical.ProcessMetaData;
import org.jbpm.compiler.canonical.ProcessToExecModelGenerator;
import org.jbpm.compiler.canonical.UserTaskModelMetaData;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.Resource;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessEventListenerConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.impl.CachedWorkItemHandlerConfig;
import org.kie.kogito.process.impl.DefaultProcessEventListenerConfig;
import org.kie.kogito.process.impl.StaticProcessConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityGenerationModelTest
extends JbpmBpmn2TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ActivityGenerationModelTest.class);
    private static final JavaCompiler JAVA_COMPILER = JavaCompilerFactory.getInstance().loadCompiler(JavaDialectConfiguration.CompilerType.NATIVE, "1.8");

    @Test
    public void testMinimalProcess() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-MinimalProcess.bpmn2")).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.legacyProcess());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("com.sample.MinimalProcess", content);
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.emptyMap());
        ProcessInstance processInstance = processes.get("Minimal").createInstance();
        processInstance.start();
        Assert.assertEquals((long)2L, (long)processInstance.status());
    }

    @Test
    public void testUserTaskProcessWithTaskModels() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-UserTask.bpmn2")).get(0);
        List models = ProcessToExecModelGenerator.INSTANCE.generateUserTaskModel((WorkflowProcess)process.legacyProcess());
        for (UserTaskModelMetaData metaData : models) {
            String content = metaData.generateInput();
            Assertions.assertThat((String)content).isNotNull();
            this.log(content);
            content = metaData.generateOutput();
            Assertions.assertThat((String)content).isNotNull();
            this.log(content);
        }
    }

    @Test
    public void testUserTaskProcess() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-UserTask.bpmn2")).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.legacyProcess());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.UserTaskProcess", content);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.singletonMap("Human Task", workItemHandler));
        ProcessInstance processInstance = processes.get("UserTask").createInstance();
        processInstance.start();
        Assert.assertEquals((long)1L, (long)processInstance.status());
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        processInstance.completeWorkItem(workItem.getId(), null);
        Assert.assertEquals((long)2L, (long)processInstance.status());
    }

    @Test
    public void testUserTaskWithParamProcess() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-UserTaskWithParametrizedInput.bpmn2")).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.legacyProcess());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.UserTaskProcess", content);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.singletonMap("Human Task", workItemHandler));
        ProcessInstance processInstance = processes.get("UserTask").createInstance();
        processInstance.start();
        Assert.assertEquals((long)1L, (long)processInstance.status());
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)("Executing task of process instance " + processInstance.id() + " as work item with Hello"), (Object)workItem.getParameter("Description").toString().trim());
        processInstance.completeWorkItem(workItem.getId(), null);
        Assert.assertEquals((long)2L, (long)processInstance.status());
    }

    @Test
    public void testScriptMultilineExprProcess() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-CallActivitySubProcess.bpmn2")).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.legacyProcess());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.SubProcessProcess", content);
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.emptyMap());
        ProcessInstance processInstance = processes.get("SubProcess").createInstance();
        processInstance.start();
        Assert.assertEquals((long)2L, (long)processInstance.status());
    }

    @Test
    public void testExclusiveSplit() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-ExclusiveSplit.bpmn2")).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.legacyProcess());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.TestProcess", content);
        SystemOutWorkItemHandler workItemHandler = new SystemOutWorkItemHandler();
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.singletonMap("Email", workItemHandler));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First");
        params.put("y", "Second");
        ProcessInstance processInstance = processes.get("com.sample.test").createInstance(BpmnVariables.create(params));
        processInstance.start();
        Assert.assertEquals((long)2L, (long)processInstance.status());
    }

    @Test
    public void testInclusiveSplit() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-InclusiveSplit.bpmn2")).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.legacyProcess());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.TestProcess", content);
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.emptyMap());
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = processes.get("com.sample.test").createInstance(BpmnVariables.create(params));
        processInstance.start();
        Assert.assertEquals((long)2L, (long)processInstance.status());
    }

    @Test
    public void testInclusiveSplitDefaultConnection() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-InclusiveGatewayWithDefault.bpmn2")).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.legacyProcess());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.InclusiveGatewayWithDefaultProcess", content);
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.emptyMap());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "c");
        ProcessInstance processInstance = processes.get("InclusiveGatewayWithDefault").createInstance(BpmnVariables.create(params));
        processInstance.start();
        Assert.assertEquals((long)2L, (long)processInstance.status());
    }

    @Test
    public void testParallelGateway() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-ParallelSplit.bpmn2")).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.legacyProcess());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.TestProcess", content);
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.emptyMap());
        HashMap params = new HashMap();
        ProcessInstance processInstance = processes.get("com.sample.test").createInstance(BpmnVariables.create(params));
        processInstance.start();
        Assert.assertEquals((long)2L, (long)processInstance.status());
    }

    @Test
    public void testInclusiveSplitAndJoinNested() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-InclusiveSplitAndJoinNested.bpmn2")).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.legacyProcess());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.TestProcess", content);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.singletonMap("Human Task", workItemHandler));
        ProcessInstance processInstance = processes.get("com.sample.test").createInstance(BpmnVariables.create(params));
        processInstance.start();
        Assert.assertEquals((long)1L, (long)processInstance.status());
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        Assert.assertEquals((long)2L, (long)activeWorkItems.size());
        for (WorkItem wi : activeWorkItems) {
            processInstance.completeWorkItem(wi.getId(), null);
        }
        activeWorkItems = workItemHandler.getWorkItems();
        Assert.assertEquals((long)2L, (long)activeWorkItems.size());
        for (WorkItem wi : activeWorkItems) {
            processInstance.completeWorkItem(wi.getId(), null);
        }
        Assert.assertEquals((long)2L, (long)processInstance.status());
    }

    @Test
    public void testWorkItemProcessWithVariableMapping() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-ServiceProcess.bpmn2")).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.legacyProcess());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.ServiceProcessProcess", content);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.singletonMap("org.jbpm.bpmn2.objects.HelloService.hello", workItemHandler));
        ProcessInstance processInstance = processes.get("ServiceProcess").createInstance(BpmnVariables.create(params));
        processInstance.start();
        Assert.assertEquals((long)1L, (long)processInstance.status());
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("Parameter"));
        processInstance.completeWorkItem(workItem.getId(), Collections.singletonMap("Result", "john doe"));
        Assert.assertEquals((long)2L, (long)processInstance.status());
    }

    @Test
    public void testBusinessRuleTaskProcess() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-BusinessRuleTask.bpmn2")).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.legacyProcess());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
    }

    @Test
    public void testServiceTaskProcess() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-ServiceProcess.bpmn2")).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.legacyProcess());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        ((IterableAssert)Assertions.assertThat((Iterable)metaData.getWorkItems()).hasSize(1)).contains((Object[])new String[]{"org.jbpm.bpmn2.objects.HelloService.hello"});
    }

    protected void log(String content) {
        LOG.info(content);
    }

    protected Map<String, BpmnProcess> createProcesses(Map<String, String> classData, Map<String, WorkItemHandler> handlers) throws Exception {
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        MemoryFileSystem trgMfs = new MemoryFileSystem();
        String[] sources = new String[classData.size()];
        int index = 0;
        for (Map.Entry<String, String> entry : classData.entrySet()) {
            String fileName = entry.getKey().replaceAll("\\.", "/") + ".java";
            sources[index++] = fileName;
            srcMfs.write(fileName, entry.getValue().getBytes());
        }
        CompilationResult result = JAVA_COMPILER.compile(sources, (ResourceReader)srcMfs, (ResourceStore)trgMfs, this.getClass().getClassLoader());
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((Object[])result.getErrors()).hasSize(0);
        CachedWorkItemHandlerConfig wiConfig = new CachedWorkItemHandlerConfig();
        for (Map.Entry entry : handlers.entrySet()) {
            wiConfig.register((String)entry.getKey(), (WorkItemHandler)entry.getValue());
        }
        StaticProcessConfig config = new StaticProcessConfig((WorkItemHandlerConfig)wiConfig, (ProcessEventListenerConfig)new DefaultProcessEventListenerConfig(new ProcessEventListener[]{new DebugProcessEventListener()}));
        TestClassLoader testClassLoader = new TestClassLoader(this.getClass().getClassLoader(), trgMfs.getMap());
        HashMap<String, BpmnProcess> processes = new HashMap<String, BpmnProcess>();
        for (String className : classData.keySet()) {
            Class<?> processClass = Class.forName(className, true, testClassLoader);
            Method processMethod = processClass.getMethod("process", new Class[0]);
            Process process = (Process)processMethod.invoke(null, new Object[0]);
            Assertions.assertThat((Object)process).isNotNull();
            processes.put(process.getId(), new BpmnProcess(process, (ProcessConfig)config));
        }
        return processes;
    }

    private static class TestClassLoader
    extends URLClassLoader {
        private final Map<String, byte[]> extraClassDefs = new HashMap<String, byte[]>();

        public TestClassLoader(ClassLoader parent, Map<String, byte[]> extraClassDefs) {
            super(new URL[0], parent);
            for (Map.Entry<String, byte[]> entry : extraClassDefs.entrySet()) {
                this.extraClassDefs.put(entry.getKey().replaceAll("/", ".").replaceFirst("\\.class", ""), entry.getValue());
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] classBytes = this.extraClassDefs.remove(name);
            if (classBytes != null) {
                return this.defineClass(name, classBytes, 0, classBytes.length);
            }
            return super.findClass(name);
        }
    }
}

