/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.concurrency;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.jbpm.bpmn2.objects.Status;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class OneProcessPerThreadTest {
    private static final int THREAD_COUNT = 1000;
    private static volatile AtomicInteger started = new AtomicInteger(0);
    private static volatile AtomicInteger done = new AtomicInteger(0);
    private static final Logger logger = LoggerFactory.getLogger(OneProcessPerThreadTest.class);

    protected KieSession createStatefulKnowledgeSession(KieBase kbase) {
        return kbase.newKieSession();
    }

    @Test
    public void testMultiThreadProcessInstanceWorkItem() throws Exception {
        final ConcurrentHashMap workItems = new ConcurrentHashMap();
        try {
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-MultiThreadServiceProcess.bpmn"), ResourceType.BPMN2);
            KieBase kbase = kbuilder.newKieBase();
            KieSession ksession = this.createStatefulKnowledgeSession(kbase);
            ksession.getWorkItemManager().registerWorkItemHandler("Log", new WorkItemHandler(){

                public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                    Long threadId = (Long)workItem.getParameter("id");
                    workItems.put(workItem.getProcessInstanceId(), threadId);
                }

                public void abortWorkItem(WorkItem arg0, WorkItemManager arg1) {
                }
            });
            OneProcessPerThreadTest.startThreads(ksession);
            Assert.assertEquals((int)1000, (int)workItems.size());
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Should not raise any exception: " + t.getMessage()));
        }
        int i = 0;
        while (started.get() > done.get()) {
            logger.info("{} > {}", (Object)started, (Object)done);
            Thread.sleep(10000L);
            if (++i <= 10) continue;
            Assert.fail((String)"Not all threads completed.");
        }
    }

    private static void startThreads(KieSession ksession) throws Throwable {
        int i;
        boolean success = true;
        Thread[] t = new Thread[1000];
        ProcessInstanceStartRunner[] r = new ProcessInstanceStartRunner[1000];
        for (i = 0; i < t.length; ++i) {
            r[i] = new ProcessInstanceStartRunner(ksession, i, "org.drools.integrationtests.multithread");
            t[i] = new Thread((Runnable)r[i], "thread-" + i);
            try {
                t[i].start();
                continue;
            }
            catch (Throwable fault) {
                Assert.fail((String)("Unable to complete test: " + fault.getMessage()));
            }
        }
        for (i = 0; i < t.length; ++i) {
            t[i].join();
            if (r[i].getStatus() != Status.FAIL) continue;
            success = false;
        }
        if (!success) {
            Assert.fail((String)"Multithread test failed. Look at the stack traces for details. ");
        }
    }

    public static class ProcessInstanceStartRunner
    implements Runnable {
        private KieSession ksession;
        private String processId;
        private long id;
        private Status status;

        public ProcessInstanceStartRunner(KieSession ksession, int id, String processId) {
            this.ksession = ksession;
            this.id = id;
            this.processId = processId;
        }

        @Override
        public void run() {
            started.incrementAndGet();
            try {
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("id", this.id);
                this.ksession.startProcess(this.processId, params);
            }
            catch (Throwable t) {
                this.status = Status.FAIL;
                logger.error("{} failed: {}", (Object)Thread.currentThread().getName(), (Object)t.getMessage());
                t.printStackTrace();
            }
            done.incrementAndGet();
        }

        public long getId() {
            return this.id;
        }

        public Status getStatus() {
            return this.status;
        }
    }
}

