/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.handler;

import java.util.HashMap;
import java.util.Map;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.kogito.process.workitem.Policy;

public class ReceiveTaskHandler
implements WorkItemHandler {
    private Map<String, String> waiting = new HashMap<String, String>();
    private ProcessRuntime ksession;

    public ReceiveTaskHandler(KieSession ksession) {
        this.ksession = ksession;
    }

    public void setKnowledgeRuntime(KieSession ksession) {
        this.ksession = ksession;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String messageId = (String)workItem.getParameter("MessageId");
        this.waiting.put(messageId, workItem.getId());
    }

    public void messageReceived(String messageId, Object message) {
        String workItemId = this.waiting.get(messageId);
        if (workItemId == null) {
            return;
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("Message", message);
        this.ksession.getWorkItemManager().completeWorkItem(workItemId, results, new Policy[0]);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        String messageId = (String)workItem.getParameter("MessageId");
        this.waiting.remove(messageId);
    }
}

