/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import java.util.HashMap;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.handler.SendTaskHandler;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class EndEventTest
extends JbpmBpmn2TestCase {
    @Test
    public void testImplicitEndParallel() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ParallelSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testErrorEndEventProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("ErrorEndEvent");
        this.assertProcessInstanceAborted(processInstance);
        Assertions.assertEquals((Object)"error", (Object)((org.jbpm.process.instance.ProcessInstance)processInstance).getOutcome());
    }

    @Test
    public void testEscalationEndEventProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("escalation/BPMN2-EscalationEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("EscalationEndEvent");
        this.assertProcessInstanceAborted(processInstance);
    }

    @Test
    public void testSignalEnd() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SignalEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ksession.startProcess("SignalEndEvent", params);
    }

    @Test
    public void testMessageEnd() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MessageEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = ksession.startProcess("MessageEndEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMessageEndVerifyDeploymentId() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MessageEndEvent.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)handler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = ksession.startProcess("MessageEndEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
        WorkItem workItem = handler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertTrue((boolean)(workItem instanceof org.drools.core.process.instance.WorkItem));
        long nodeInstanceId = ((org.drools.core.process.instance.WorkItem)workItem).getNodeInstanceId();
        long nodeId = ((org.drools.core.process.instance.WorkItem)workItem).getNodeId();
        String deploymentId = ((org.drools.core.process.instance.WorkItem)workItem).getDeploymentId();
        Assertions.assertNotNull((Object)nodeId);
        Assertions.assertTrue((nodeId > 0L ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)nodeInstanceId);
        Assertions.assertTrue((nodeInstanceId > 0L ? 1 : 0) != 0);
        Assertions.assertNull((Object)deploymentId);
        ksession.getEnvironment().set("deploymentId", (Object)"testDeploymentId");
        processInstance = ksession.startProcess("MessageEndEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
        workItem = handler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertTrue((boolean)(workItem instanceof org.drools.core.process.instance.WorkItem));
        nodeInstanceId = ((org.drools.core.process.instance.WorkItem)workItem).getNodeInstanceId();
        nodeId = ((org.drools.core.process.instance.WorkItem)workItem).getNodeId();
        deploymentId = ((org.drools.core.process.instance.WorkItem)workItem).getDeploymentId();
        Assertions.assertNotNull((Object)nodeId);
        Assertions.assertTrue((nodeId > 0L ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)nodeInstanceId);
        Assertions.assertTrue((nodeInstanceId > 0L ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)deploymentId);
        Assertions.assertEquals((Object)"testDeploymentId", (Object)deploymentId);
    }

    @Test
    public void testOnEntryExitScript() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-OnEntryExitScriptProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new SystemOutWorkItemHandler());
        ArrayList myList = new ArrayList();
        ksession.setGlobal("list", myList);
        ProcessInstance processInstance = ksession.startProcess("OnEntryExitScriptProcess");
        this.assertProcessInstanceCompleted(processInstance);
        Assertions.assertEquals((int)4, (int)myList.size());
    }

    @Test
    public void testOnEntryExitNamespacedScript() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-OnEntryExitNamespacedScriptProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new SystemOutWorkItemHandler());
        ArrayList myList = new ArrayList();
        ksession.setGlobal("list", myList);
        ProcessInstance processInstance = ksession.startProcess("OnEntryExitScriptProcess");
        this.assertProcessInstanceCompleted(processInstance);
        Assertions.assertEquals((int)4, (int)myList.size());
    }

    @Test
    public void testOnEntryExitMixedNamespacedScript() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-OnEntryExitMixedNamespacedScriptProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new SystemOutWorkItemHandler());
        ArrayList myList = new ArrayList();
        ksession.setGlobal("list", myList);
        ProcessInstance processInstance = ksession.startProcess("OnEntryExitScriptProcess");
        this.assertProcessInstanceCompleted(processInstance);
        Assertions.assertEquals((int)4, (int)myList.size());
    }

    @Test
    public void testOnEntryExitScriptDesigner() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-OnEntryExitDesignerScriptProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new SystemOutWorkItemHandler());
        ArrayList myList = new ArrayList();
        ksession.setGlobal("list", myList);
        ProcessInstance processInstance = ksession.startProcess("OnEntryExitScriptProcess");
        this.assertProcessInstanceCompleted(processInstance);
        Assertions.assertEquals((int)4, (int)myList.size());
    }

    @Test
    public void testTerminateWithinSubprocessEnd() throws Exception {
        KieBase kbase = this.createKnowledgeBase("subprocess/BPMN2-SubprocessWithParallelSpitTerminate.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("BPMN2-SubprocessWithParallelSpitTerminate");
        ksession.signalEvent("signal1", null, processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testTerminateEnd() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ParallelSpitTerminate.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("BPMN2-ParallelSpitTerminate");
        ksession.signalEvent("Signal 1", null, processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testSignalEndWithData() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EndEventSignalWithData.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap params = new HashMap();
        ProcessInstance processInstance = ksession.startProcess("src.simpleEndSignal", params);
        this.assertProcessInstanceCompleted(processInstance);
    }
}

