/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.core.SessionConfiguration;
import org.drools.core.audit.WorkingMemoryInMemoryLogger;
import org.drools.core.audit.event.LogEvent;
import org.drools.core.audit.event.RuleFlowLogEvent;
import org.drools.core.audit.event.RuleFlowNodeLogEvent;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.core.util.MVELSafeHelper;
import org.drools.core.xml.SemanticModule;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNExtensionsSemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.io.Resource;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Timeout(value=3000L, unit=TimeUnit.SECONDS)
public abstract class JbpmBpmn2TestCase {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected KieSession ksession;
    protected WorkingMemoryInMemoryLogger workingMemoryLogger;

    @AfterEach
    public void disposeSession() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @BeforeEach
    protected void logTestStart(TestInfo testInfo) {
        this.logger.info(" >>> {} <<<", (Object)testInfo.getDisplayName());
    }

    @AfterEach
    protected void logTestEnd(TestInfo testInfo) {
        this.logger.info("Finished {}", (Object)testInfo.getDisplayName());
    }

    @AfterEach
    public void clear() {
        this.clearHistory();
    }

    protected KieBase createKnowledgeBase(String ... process) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (int i = 0; i < process.length; ++i) {
            resources.addAll(this.buildAndDumpBPMN2Process(process[i]));
        }
        return this.createKnowledgeBaseFromResources(resources.toArray(new Resource[resources.size()]));
    }

    protected KieBase createKnowledgeBaseWithoutDumper(String ... process) throws Exception {
        Resource[] resources = new Resource[process.length];
        for (int i = 0; i < process.length; ++i) {
            String p = process[i];
            resources[i] = ResourceFactory.newClassPathResource((String)p);
        }
        return this.createKnowledgeBaseFromResources(resources);
    }

    protected List<Resource> buildAndDumpBPMN2Process(String process) throws SAXException, IOException {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        ((KnowledgeBuilderConfigurationImpl)conf).initSemanticModules();
        ((KnowledgeBuilderConfigurationImpl)conf).addSemanticModule((SemanticModule)new BPMNSemanticModule());
        ((KnowledgeBuilderConfigurationImpl)conf).addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        ((KnowledgeBuilderConfigurationImpl)conf).addSemanticModule((SemanticModule)new BPMNExtensionsSemanticModule());
        Resource classpathResource = ResourceFactory.newClassPathResource((String)process);
        XmlProcessReader processReader = new XmlProcessReader(((KnowledgeBuilderConfigurationImpl)conf).getSemanticModules(), this.getClass().getClassLoader());
        List processes = processReader.read(this.getClass().getResourceAsStream("/" + process));
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Process p : processes) {
            RuleFlowProcess ruleFlowProcess = (RuleFlowProcess)p;
            String dumpedString = XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)ruleFlowProcess);
            Resource resource = ResourceFactory.newReaderResource((Reader)new StringReader(dumpedString));
            resource.setSourcePath(classpathResource.getSourcePath());
            resource.setTargetPath(classpathResource.getTargetPath());
            resources.add(resource);
        }
        return resources;
    }

    protected KieBase createKnowledgeBaseFromResources(Resource ... process) throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        if (process.length > 0) {
            KieFileSystem kfs = ks.newKieFileSystem();
            for (Resource p : process) {
                kfs.write(p);
            }
            KieBuilder kb = ks.newKieBuilder(kfs);
            kb.buildAll();
            if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
                throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
            }
        }
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        return kContainer.getKieBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KieBase createKnowledgeBaseFromDisc(String process) throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        KieFileSystem kfs = ks.newKieFileSystem();
        Resource res = ResourceFactory.newClassPathResource((String)process);
        kfs.write(res);
        KieBuilder kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        KieBase kbase = kContainer.getKieBase();
        File packageFile = null;
        Iterator iterator = kbase.getKiePackages().iterator();
        if (iterator.hasNext()) {
            KiePackage pkg = (KiePackage)iterator.next();
            packageFile = new File(System.getProperty("java.io.tmpdir") + File.separator + pkg.getName() + ".pkg");
            packageFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(packageFile);){
                DroolsStreamUtils.streamOut((OutputStream)out, (Object)pkg);
            }
        }
        kfs.delete(new String[]{res.getSourcePath()});
        kfs.write(ResourceFactory.newFileResource(packageFile));
        kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        kbase = kContainer.getKieBase();
        return kbase;
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KieBase kbase) throws Exception {
        return this.createKnowledgeSession(kbase, null, null);
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KieBase kbase, Environment env) throws Exception {
        return this.createKnowledgeSession(kbase, null, env);
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KieBase kbase, KieSessionConfiguration conf, Environment env) throws Exception {
        if (conf == null) {
            conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        }
        if (env == null) {
            env = EnvironmentFactory.newEnvironment();
        }
        Properties defaultProps = new Properties();
        defaultProps.setProperty("drools.processSignalManagerFactory", DefaultSignalManagerFactory.class.getName());
        defaultProps.setProperty("drools.processInstanceManagerFactory", DefaultProcessInstanceManagerFactory.class.getName());
        conf = SessionConfiguration.newInstance((Properties)defaultProps);
        conf.setOption((KieSessionOption)ForceEagerActivationOption.YES);
        StatefulKnowledgeSession result = (StatefulKnowledgeSession)kbase.newKieSession(conf, env);
        this.workingMemoryLogger = new WorkingMemoryInMemoryLogger((KieRuntimeEventManager)result);
        return result;
    }

    protected StatefulKnowledgeSession createKnowledgeSession(String ... process) throws Exception {
        KieBase kbase = this.createKnowledgeBase(process);
        return this.createKnowledgeSession(kbase);
    }

    protected KieSession restoreSession(KieSession ksession, boolean noCache) {
        return ksession;
    }

    protected KieSession restoreSession(KieSession ksession) {
        return ksession;
    }

    protected StatefulKnowledgeSession restoreSession(StatefulKnowledgeSession ksession) {
        return ksession;
    }

    public void assertProcessInstanceCompleted(ProcessInstance processInstance) {
        Assertions.assertTrue((boolean)this.assertProcessInstanceState(2, processInstance), (String)"Process instance has not been completed.");
    }

    public void assertProcessInstanceAborted(ProcessInstance processInstance) {
        Assertions.assertTrue((boolean)this.assertProcessInstanceState(3, processInstance), (String)"Process instance has not been aborted.");
    }

    public void assertProcessInstanceActive(ProcessInstance processInstance) {
        Assertions.assertTrue((this.assertProcessInstanceState(1, processInstance) || this.assertProcessInstanceState(0, processInstance) ? 1 : 0) != 0, (String)"Process instance is not active.");
    }

    public void assertProcessInstanceFinished(ProcessInstance processInstance, KieSession ksession) {
        Assertions.assertNull((Object)ksession.getProcessInstance(processInstance.getId()), (String)"Process instance has not been finished.");
    }

    public void assertNodeActive(long processInstanceId, KieSession ksession, String ... name) {
        ArrayList<String> names = new ArrayList<String>();
        for (String n : name) {
            names.add(n);
        }
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        if (processInstance instanceof WorkflowProcessInstance) {
            this.assertNodeActive((NodeInstanceContainer)((WorkflowProcessInstance)processInstance), names);
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            Assertions.fail((String)("Node(s) not active: " + s));
        }
    }

    private void assertNodeActive(NodeInstanceContainer container, List<String> names) {
        for (NodeInstance nodeInstance : container.getNodeInstances()) {
            String nodeName = nodeInstance.getNodeName();
            if (names.contains(nodeName)) {
                names.remove(nodeName);
            }
            if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
            this.assertNodeActive((NodeInstanceContainer)nodeInstance, names);
        }
    }

    public void assertNodeTriggered(long processInstanceId, String ... nodeNames) {
        List<String> names = this.getNotTriggeredNodes(processInstanceId, nodeNames);
        if (!names.isEmpty()) {
            String s = names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + names.get(i);
            }
            Assertions.fail((String)("Node(s) not executed: " + s));
        }
    }

    public void assertNotNodeTriggered(long processInstanceId, String ... nodeNames) {
        List<String> names = this.getNotTriggeredNodes(processInstanceId, nodeNames);
        Assertions.assertTrue((boolean)Arrays.equals(names.toArray(), nodeNames));
    }

    public int getNumberOfNodeTriggered(long processInstanceId, String node) {
        int counter = 0;
        for (LogEvent event : this.workingMemoryLogger.getLogEvents()) {
            String nodeName;
            if (!(event instanceof RuleFlowNodeLogEvent) || !node.equals(nodeName = ((RuleFlowNodeLogEvent)event).getNodeName())) continue;
            ++counter;
        }
        return counter;
    }

    public int getNumberOfProcessInstances(String processId) {
        LogEvent[] events;
        int counter = 0;
        for (LogEvent event : events = this.workingMemoryLogger.getLogEvents().toArray(new LogEvent[0])) {
            if (event.getType() != 8 || !((RuleFlowLogEvent)event).getProcessId().equals(processId)) continue;
            ++counter;
        }
        return counter;
    }

    protected boolean assertProcessInstanceState(int state, ProcessInstance processInstance) {
        return processInstance.getState() == state;
    }

    private List<String> getNotTriggeredNodes(long processInstanceId, String ... nodeNames) {
        ArrayList<String> names = new ArrayList<String>();
        for (String nodeName : nodeNames) {
            names.add(nodeName);
        }
        for (LogEvent event : this.workingMemoryLogger.getLogEvents()) {
            String nodeName;
            if (!(event instanceof RuleFlowNodeLogEvent) || !names.contains(nodeName = ((RuleFlowNodeLogEvent)event).getNodeName())) continue;
            names.remove(nodeName);
        }
        return names;
    }

    protected List<String> getCompletedNodes(long processInstanceId) {
        ArrayList<String> names = new ArrayList<String>();
        for (LogEvent event : this.workingMemoryLogger.getLogEvents()) {
            if (!(event instanceof RuleFlowNodeLogEvent) || event.getType() != 27) continue;
            names.add(((RuleFlowNodeLogEvent)event).getNodeId());
        }
        return names;
    }

    protected void clearHistory() {
        if (this.workingMemoryLogger != null) {
            this.workingMemoryLogger.clear();
        }
    }

    public void assertProcessVarExists(ProcessInstance process, String ... processVarNames) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        ArrayList<String> names = new ArrayList<String>();
        for (String nodeName : processVarNames) {
            names.add(nodeName);
        }
        for (String pvar : instance.getVariables().keySet()) {
            if (!names.contains(pvar)) continue;
            names.remove(pvar);
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            Assertions.fail((String)("Process Variable(s) do not exist: " + s));
        }
    }

    public String getProcessVarValue(ProcessInstance processInstance, String varName) {
        String actualValue = null;
        Object value = ((WorkflowProcessInstanceImpl)processInstance).getVariable(varName);
        if (value != null) {
            actualValue = value.toString();
        }
        return actualValue;
    }

    public void assertProcessVarValue(ProcessInstance processInstance, String varName, Object varValue) {
        String actualValue = this.getProcessVarValue(processInstance, varName);
        Assertions.assertEquals((Object)varValue, (Object)actualValue, (String)("Variable " + varName + " value misatch!"));
    }

    public void assertNodeExists(ProcessInstance process, String ... nodeNames) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        ArrayList<String> names = new ArrayList<String>();
        for (String string : nodeNames) {
            names.add(string);
        }
        for (String string : instance.getNodeContainer().getNodes()) {
            if (!names.contains(string.getName())) continue;
            names.remove(string.getName());
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            Assertions.fail((String)("Node(s) do not exist: " + s));
        }
    }

    public void assertNumOfIncommingConnections(ProcessInstance process, String nodeName, int num) {
        this.assertNodeExists(process, nodeName);
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        for (Node node : instance.getNodeContainer().getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            if (node.getIncomingConnections().size() == num) break;
            Assertions.fail((String)("Expected incomming connections: " + num + " - found " + node.getIncomingConnections().size()));
        }
    }

    public void assertNumOfOutgoingConnections(ProcessInstance process, String nodeName, int num) {
        this.assertNodeExists(process, nodeName);
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        for (Node node : instance.getNodeContainer().getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            if (node.getOutgoingConnections().size() == num) break;
            Assertions.fail((String)("Expected outgoing connections: " + num + " - found " + node.getOutgoingConnections().size()));
        }
    }

    public void assertVersionEquals(ProcessInstance process, String version) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getVersion().equals(version)) {
            Assertions.fail((String)("Expected version: " + version + " - found " + instance.getWorkflowProcess().getVersion()));
        }
    }

    public void assertProcessNameEquals(ProcessInstance process, String name) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getName().equals(name)) {
            Assertions.fail((String)("Expected name: " + name + " - found " + instance.getWorkflowProcess().getName()));
        }
    }

    public void assertPackageNameEquals(ProcessInstance process, String packageName) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getPackageName().equals(packageName)) {
            Assertions.fail((String)("Expected package name: " + packageName + " - found " + instance.getWorkflowProcess().getPackageName()));
        }
    }

    public Object eval(Reader reader, Map vars) {
        try {
            return this.eval(this.toString(reader), vars);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception Thrown", e);
        }
    }

    private String toString(Reader reader) throws IOException {
        int charValue;
        StringBuilder sb = new StringBuilder(1024);
        while ((charValue = reader.read()) != -1) {
            sb.append((char)charValue);
        }
        return sb.toString();
    }

    public Object eval(String str, Map vars) {
        ParserContext context = new ParserContext();
        context.addPackageImport("org.jbpm.task");
        context.addPackageImport("org.jbpm.task.service");
        context.addPackageImport("org.jbpm.task.query");
        context.addPackageImport("java.util");
        vars.put("now", new Date());
        return MVELSafeHelper.getEvaluator().executeExpression((Object)MVEL.compileExpression((String)str, (ParserContext)context), vars);
    }

    protected void assertProcessInstanceCompleted(long processInstanceId, KieSession ksession) {
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        Assertions.assertNull((Object)processInstance, (String)"Process instance has not completed.");
    }

    protected void assertProcessInstanceAborted(long processInstanceId, KieSession ksession) {
        Assertions.assertNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    protected void assertProcessInstanceActive(long processInstanceId, KieSession ksession) {
        Assertions.assertNotNull((Object)ksession.getProcessInstance(processInstanceId));
    }
}

