/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.KieBase;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.SLAViolatedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class SLAComplianceTest
extends JbpmBpmn2TestCase {
    @Test
    public void testSLAonProcessViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLA.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)slaViolated, (String)"SLA was not violated while it is expected");
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonProcessMet() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLA.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)2, (int)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonUserTaskViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLAOnTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)slaViolated, (String)"SLA was not violated while it is expected");
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)0, (int)slaCompliance);
        Collection active = ((WorkflowProcessInstance)processInstance).getNodeInstances();
        Assertions.assertEquals((int)1, (int)active.size());
        NodeInstance userTaskNode = (NodeInstance)active.iterator().next();
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 0);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)0, (int)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 1);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonUserTaskMet() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLAOnTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Collection active = ((WorkflowProcessInstance)processInstance).getNodeInstances();
        Assertions.assertEquals((int)1, (int)active.size());
        NodeInstance userTaskNode = (NodeInstance)active.iterator().next();
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)0, (int)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 0);
        Assertions.assertEquals((int)2, (int)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 1);
        Assertions.assertEquals((int)2, (int)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonProcessViolatedExternalTracking() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLA.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        ksession.getEnvironment().set("SLATimerMode", (Object)"false");
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)slaViolated, (String)"SLA should not violated by timer");
        ksession.signalEvent("slaViolation", null, processInstance.getId());
        slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)slaViolated, (String)"SLA was not violated while it is expected");
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonUserTaskViolatedExternalTracking() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLAOnTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        ksession.getEnvironment().set("SLATimerMode", (Object)"false");
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)slaViolated, (String)"SLA should not violated by timer");
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Collection active = ((WorkflowProcessInstance)processInstance).getNodeInstances();
        Assertions.assertEquals((int)1, (int)active.size());
        NodeInstance userTaskNode = (NodeInstance)active.iterator().next();
        ksession.signalEvent("slaViolation:" + userTaskNode.getId(), null, processInstance.getId());
        slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)slaViolated, (String)"SLA was not violated while it is expected");
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)0, (int)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 0);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 1);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonProcessViolatedWithExpression() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLAExpr.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("s", "3s");
        ProcessInstance processInstance = ksession.startProcess("UserTask", parameters);
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)slaViolated, (String)"SLA was not violated while it is expected");
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonProcessViolatedNoTracking() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLA.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        ksession.getEnvironment().set("SLATimerMode", (Object)"false");
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)slaViolated, (String)"SLA should not violated by timer");
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)1, (int)slaCompliance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonCatchEventViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignalWithSLAOnEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.addEventListener((ProcessEventListener)listener);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)slaViolated, (String)"SLA should be violated by timer");
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Collection active = ((WorkflowProcessInstance)processInstance).getNodeInstances();
        Assertions.assertEquals((int)1, (int)active.size());
        NodeInstance eventNode = (NodeInstance)active.iterator().next();
        ksession.signalEvent("MyMessage", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)0, (int)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)eventNode, 0);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)eventNode, 1);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonCatchEventNotViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignalWithSLAOnEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.addEventListener((ProcessEventListener)listener);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Collection active = ((WorkflowProcessInstance)processInstance).getNodeInstances();
        Assertions.assertEquals((int)1, (int)active.size());
        NodeInstance eventNode = (NodeInstance)active.iterator().next();
        ksession.signalEvent("MyMessage", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)0, (int)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)eventNode, 1);
        Assertions.assertEquals((int)2, (int)slaCompliance);
        boolean slaViolated = latch.await(3L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)slaViolated, (String)"SLA should not violated by timer");
        ksession.dispose();
    }

    private int getSLAComplianceForProcessInstance(ProcessInstance processInstance) {
        int slaCompliance = ((org.jbpm.process.instance.ProcessInstance)processInstance).getSlaCompliance();
        return slaCompliance;
    }

    private int getSLAComplianceForNodeInstance(long processInstanceId, org.jbpm.workflow.instance.NodeInstance nodeInstance, int logType) {
        int slaCompliance = nodeInstance.getSlaCompliance();
        return slaCompliance;
    }
}

