/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.handler;

import java.util.HashMap;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.handler.ErrornousWorkItemHandler;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.ProcessWorkItemHandlerException;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class WorkItemHandlerExceptionHandlingTest
extends JbpmBpmn2TestCase {
    private static Boolean strictVariableSetting = Boolean.parseBoolean(System.getProperty("org.jbpm.variable.strict", "false"));

    @BeforeAll
    public static void setup() throws Exception {
        VariableScope.setVariableStrictOption((boolean)false);
        WorkItemNodeInstance.setVariableStrictOption((boolean)false);
    }

    @AfterAll
    public static void clean() throws Exception {
        VariableScope.setVariableStrictOption((boolean)strictVariableSetting);
        WorkItemNodeInstance.setVariableStrictOption((boolean)strictVariableSetting);
    }

    @Test
    public void testErrornousHandlerWithStrategyComplete() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ScriptTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ScriptTask", ProcessWorkItemHandlerException.HandlingStrategy.COMPLETE);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("com.sample.boolean");
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        this.assertProcessVarValue(processInstance, "isChecked", "true");
        WorkItem handledWorkItem = workItemHandler.getWorkItem();
        Assertions.assertEquals((int)2, (int)handledWorkItem.getState());
    }

    @Test
    public void testErrornousHandlerWithStrategyCompleteWaitState() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ReceiveTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ReceiveTask", ProcessWorkItemHandlerException.HandlingStrategy.COMPLETE);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)testHandler);
        ProcessInstance processInstance = ksession.startProcess("com.sample.boolean");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        WorkItem receiveWorkItem = testHandler.getWorkItem();
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        results.put("Message", true);
        ksession.getWorkItemManager().completeWorkItem(receiveWorkItem.getId(), results);
        this.assertProcessVarValue(processInstance, "isChecked", "true");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testErrornousHandlerWithStrategyAbort() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ScriptTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ScriptTask", ProcessWorkItemHandlerException.HandlingStrategy.ABORT);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isChecked", false);
        ProcessInstance processInstance = ksession.startProcess("com.sample.boolean", params);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        this.assertProcessVarValue(processInstance, "isChecked", "false");
        WorkItem handledWorkItem = workItemHandler.getWorkItem();
        Assertions.assertEquals((int)3, (int)handledWorkItem.getState());
    }

    @Test
    public void testErrornousHandlerWithStrategyAbortWaitState() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ReceiveTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ReceiveTask", ProcessWorkItemHandlerException.HandlingStrategy.ABORT);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)testHandler);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isChecked", false);
        ProcessInstance processInstance = ksession.startProcess("com.sample.boolean", params);
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        WorkItem receiveWorkItem = testHandler.getWorkItem();
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        results.put("Message", true);
        ksession.getWorkItemManager().completeWorkItem(receiveWorkItem.getId(), results);
        this.assertProcessVarValue(processInstance, "isChecked", "false");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testErrornousHandlerWithStrategyRethrow() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ScriptTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ScriptTask", ProcessWorkItemHandlerException.HandlingStrategy.RETHROW);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        try {
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("isChecked", false);
            ksession.startProcess("com.sample.boolean", params);
            Assertions.fail((String)"Should fail since strategy is rethrow");
        }
        catch (WorkflowRuntimeException e) {
            Assertions.assertEquals((Object)"On purpose", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testErrornousHandlerWithStrategyRetry() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ScriptTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ScriptTask", ProcessWorkItemHandlerException.HandlingStrategy.RETRY);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isChecked", false);
        ProcessInstance processInstance = ksession.startProcess("com.sample.boolean", params);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        this.assertProcessVarValue(processInstance, "isChecked", "true");
    }

    @Test
    public void testErrornousHandlerWithStrategyRetryWaitState() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ReceiveTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ReceiveTask", ProcessWorkItemHandlerException.HandlingStrategy.RETRY);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)testHandler);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isChecked", false);
        ProcessInstance processInstance = ksession.startProcess("com.sample.boolean", params);
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        WorkItem receiveWorkItem = testHandler.getWorkItem();
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        results.put("Message", true);
        ksession.getWorkItemManager().completeWorkItem(receiveWorkItem.getId(), results);
        this.assertProcessVarValue(processInstance, "isChecked", "true");
    }
}

