/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.structureref;

import com.thoughtworks.xstream.XStream;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.datatype.impl.coverter.TypeConverterRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class StructureRefTest
extends JbpmBpmn2TestCase {
    @Test
    public void testStringStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-StringStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "test value");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testBooleanStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-BooleanStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "true");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testIntegerStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-IntegerStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "25");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testFloatStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-FloatStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "5.5");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testObjectStructureRef() throws Exception {
        String personAsXml = "<org.jbpm.bpmn2.objects.Person><id>1</id><name>john</name></org.jbpm.bpmn2.objects.Person>";
        TypeConverterRegistry.get().register("org.jbpm.bpmn2.objects.Person", s -> new XStream().fromXML(personAsXml));
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-ObjectStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", personAsXml);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testDefaultObjectStructureRef() throws Exception {
        String value = "simple text for testing";
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DefaultObjectStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", value);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testNoStructureRef() throws Exception {
        Person person = new Person();
        person.setId(1L);
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-NoStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, Person> res = new HashMap<String, Person>();
        res.put("testHT", person);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testNotExistingVarBooleanStructureRefOnStart() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-BooleanStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("not existing", "invalid boolean");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StructureRefTest.lambda$testNotExistingVarBooleanStructureRefOnStart$1((KieSession)ksession, params));
    }

    @Test
    public void testInvalidBooleanStructureRefOnStart() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-BooleanStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "invalid boolean");
        Assertions.assertThrows(IllegalArgumentException.class, () -> StructureRefTest.lambda$testInvalidBooleanStructureRefOnStart$2((KieSession)ksession, params));
    }

    @Test
    public void testInvalidBooleanStructureRefOnWIComplete() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-IntegerStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, Boolean> res = new HashMap<String, Boolean>();
        res.put("testHT", true);
        try {
            ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
            Assertions.fail();
        }
        catch (IllegalArgumentException iae) {
            this.logger.info("Expected IllegalArgumentException caught: " + iae);
        }
        catch (Exception e) {
            Assertions.fail();
        }
    }

    @Test
    public void testInvalidBooleanStructureRefOnStartVerifyErrorMsg() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-BooleanStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("test", "invalid boolean");
            ksession.startProcess("StructureRef", params);
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Variable 'test' has incorrect data type expected:java.lang.Boolean actual:java.lang.String", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidBooleanStructureRefOnStartWithDisabledCheck() throws Exception {
        VariableScope.setVariableStrictOption((boolean)false);
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-BooleanStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "invalid boolean");
        ksession.startProcess("StructureRef", params);
        VariableScope.setVariableStrictOption((boolean)true);
    }

    @Test
    public void testNotExistingBooleanStructureRefOnWIComplete() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-IntegerStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        String wrongDataOutput = "not existing";
        HashMap<String, Boolean> res = new HashMap<String, Boolean>();
        res.put(wrongDataOutput, true);
        try {
            ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
            Assertions.fail();
        }
        catch (IllegalArgumentException iae) {
            System.out.println("Expected IllegalArgumentException catched: " + iae);
            Assertions.assertEquals((Object)("Data output '" + wrongDataOutput + "' is not defined in process 'StructureRef' for task 'User Task'"), (Object)iae.getMessage());
        }
        catch (Exception e) {
            Assertions.fail();
        }
    }

    private static /* synthetic */ void lambda$testInvalidBooleanStructureRefOnStart$2(KieSession ksession, Map params) throws Throwable {
        ksession.startProcess("StructureRef", params);
    }

    private static /* synthetic */ void lambda$testNotExistingVarBooleanStructureRefOnStart$1(KieSession ksession, Map params) throws Throwable {
        ksession.startProcess("StructureRef", params);
    }
}

