/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCountDownProcessEventListener
extends DefaultProcessEventListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCountDownProcessEventListener.class);
    protected CountDownLatch latch;

    public DefaultCountDownProcessEventListener() {
    }

    public DefaultCountDownProcessEventListener(int threads) {
        this.latch = new CountDownLatch(threads);
    }

    public void waitTillCompleted() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            logger.debug("Interrputed thread while waiting for all triggers");
        }
    }

    public void waitTillCompleted(long timeOut) {
        try {
            this.latch.await(timeOut, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.debug("Interrputed thread while waiting for all triggers");
        }
    }

    public void reset(int threads) {
        this.latch = new CountDownLatch(threads);
    }

    protected void countDown() {
        this.latch.countDown();
    }
}

